package org.jboss.shrinkwrap.descriptor.impl.jbosscommon51; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.LoaderRepositoryType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.LoaderRepositoryConfigType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon51.LoaderRepositoryConfigTypeImpl;

/**
 * This class implements the <code> loader-repositoryType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class LoaderRepositoryTypeImpl<T> implements Child<T>, LoaderRepositoryType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public LoaderRepositoryTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public LoaderRepositoryTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: LoaderRepositoryType ElementName: text ElementType : loader-repositoryType
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the body text for the element <code>loader-repositoryType</code> 
    * @param loaderRepositoryType the value for the body text <code>loader-repositoryType</code> 
    * @return the current instance of <code>LoaderRepositoryType<T></code> 
    */
   public LoaderRepositoryType<T> text(String value)
   {
      childNode.text(value);
      return this;
   }

   /**
    * Returns the body text of the element <code>loader-repositoryType</code> 
    * @return the value defined for the text <code>loader-repositoryType</code> 
    */
   public String getText()
   {
      return childNode.getText();
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: LoaderRepositoryType ElementName: jboss:loader-repository-configType ElementType : loader-repository-config
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>loader-repository-config</code> element will be created and returned.
    * Otherwise, the first existing <code>loader-repository-config</code> element will be returned.
    * @return the instance defined for the element <code>loader-repository-config</code> 
    */
   public LoaderRepositoryConfigType<LoaderRepositoryType<T>> getOrCreateLoaderRepositoryConfig()
   {
      List<Node> nodeList = childNode.get("loader-repository-config");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new LoaderRepositoryConfigTypeImpl<LoaderRepositoryType<T>>(this, "loader-repository-config", childNode, nodeList.get(0));
      }
      return createLoaderRepositoryConfig();
   }

   /**
    * Creates a new <code>loader-repository-config</code> element 
    * @return the new created instance of <code>LoaderRepositoryConfigType<LoaderRepositoryType<T>></code> 
    */
   public LoaderRepositoryConfigType<LoaderRepositoryType<T>> createLoaderRepositoryConfig()
   {
      return new LoaderRepositoryConfigTypeImpl<LoaderRepositoryType<T>>(this, "loader-repository-config", childNode);
   }

   /**
    * Returns all <code>loader-repository-config</code> elements
    * @return list of <code>loader-repository-config</code> 
    */
   public List<LoaderRepositoryConfigType<LoaderRepositoryType<T>>> getAllLoaderRepositoryConfig()
   {
      List<LoaderRepositoryConfigType<LoaderRepositoryType<T>>> list = new ArrayList<LoaderRepositoryConfigType<LoaderRepositoryType<T>>>();
      List<Node> nodeList = childNode.get("loader-repository-config");
      for(Node node: nodeList)
      {
         LoaderRepositoryConfigType<LoaderRepositoryType<T>>  type = new LoaderRepositoryConfigTypeImpl<LoaderRepositoryType<T>>(this, "loader-repository-config", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>loader-repository-config</code> elements 
    * @return the current instance of <code>LoaderRepositoryConfigType<LoaderRepositoryType<T>></code> 
    */
   public LoaderRepositoryType<T> removeAllLoaderRepositoryConfig()
   {
      childNode.removeChildren("loader-repository-config");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: LoaderRepositoryType ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>LoaderRepositoryType<T></code> 
    */
   public LoaderRepositoryType<T> id(String id)
   {
      childNode.attribute("id", id);
      return this;
   }

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
      public String getId()
   {
      return childNode.getAttribute("id");
   }

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>LoaderRepositoryType<T></code> 
    */
   public LoaderRepositoryType<T> removeId()
   {
      childNode.removeAttribute("id");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: LoaderRepositoryType ElementName: xsd:string ElementType : loaderRepositoryClass
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>loaderRepositoryClass</code> attribute
    * @param loaderRepositoryClass the value for the attribute <code>loaderRepositoryClass</code> 
    * @return the current instance of <code>LoaderRepositoryType<T></code> 
    */
   public LoaderRepositoryType<T> loaderRepositoryClass(String loaderRepositoryClass)
   {
      childNode.attribute("loaderRepositoryClass", loaderRepositoryClass);
      return this;
   }

   /**
    * Returns the <code>loaderRepositoryClass</code> attribute
    * @return the value defined for the attribute <code>loaderRepositoryClass</code> 
    */
      public String getLoaderRepositoryClass()
   {
      return childNode.getAttribute("loaderRepositoryClass");
   }

   /**
    * Removes the <code>loaderRepositoryClass</code> attribute 
    * @return the current instance of <code>LoaderRepositoryType<T></code> 
    */
   public LoaderRepositoryType<T> removeLoaderRepositoryClass()
   {
      childNode.removeAttribute("loaderRepositoryClass");
      return this;
   }
}
