package org.jboss.shrinkwrap.descriptor.impl.jbosscommon51; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.WebserviceDescriptionType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;

/**
 * This class implements the <code> webservice-descriptionType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class WebserviceDescriptionTypeImpl<T> implements Child<T>, WebserviceDescriptionType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public WebserviceDescriptionTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public WebserviceDescriptionTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: WebserviceDescriptionType ElementName: xsd:string ElementType : webservice-description-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>webservice-description-name</code> element
    * @param webserviceDescriptionName the value for the element <code>webservice-description-name</code> 
    * @return the current instance of <code>WebserviceDescriptionType<T></code> 
    */
   public WebserviceDescriptionType<T> webserviceDescriptionName(String webserviceDescriptionName)
   {
      childNode.getOrCreate("webservice-description-name").text(webserviceDescriptionName);
      return this;
   }

   /**
    * Returns the <code>webservice-description-name</code> element
    * @return the node defined for the element <code>webservice-description-name</code> 
    */
   public String getWebserviceDescriptionName()
   {
      return childNode.getTextValueForPatternName("webservice-description-name");
   }

   /**
    * Removes the <code>webservice-description-name</code> element 
    * @return the current instance of <code>WebserviceDescriptionType<T></code> 
    */
   public WebserviceDescriptionType<T> removeWebserviceDescriptionName()
   {
      childNode.removeChildren("webservice-description-name");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: WebserviceDescriptionType ElementName: xsd:string ElementType : config-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>config-name</code> element
    * @param configName the value for the element <code>config-name</code> 
    * @return the current instance of <code>WebserviceDescriptionType<T></code> 
    */
   public WebserviceDescriptionType<T> configName(String configName)
   {
      childNode.getOrCreate("config-name").text(configName);
      return this;
   }

   /**
    * Returns the <code>config-name</code> element
    * @return the node defined for the element <code>config-name</code> 
    */
   public String getConfigName()
   {
      return childNode.getTextValueForPatternName("config-name");
   }

   /**
    * Removes the <code>config-name</code> element 
    * @return the current instance of <code>WebserviceDescriptionType<T></code> 
    */
   public WebserviceDescriptionType<T> removeConfigName()
   {
      childNode.removeChildren("config-name");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: WebserviceDescriptionType ElementName: xsd:string ElementType : config-file
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>config-file</code> element
    * @param configFile the value for the element <code>config-file</code> 
    * @return the current instance of <code>WebserviceDescriptionType<T></code> 
    */
   public WebserviceDescriptionType<T> configFile(String configFile)
   {
      childNode.getOrCreate("config-file").text(configFile);
      return this;
   }

   /**
    * Returns the <code>config-file</code> element
    * @return the node defined for the element <code>config-file</code> 
    */
   public String getConfigFile()
   {
      return childNode.getTextValueForPatternName("config-file");
   }

   /**
    * Removes the <code>config-file</code> element 
    * @return the current instance of <code>WebserviceDescriptionType<T></code> 
    */
   public WebserviceDescriptionType<T> removeConfigFile()
   {
      childNode.removeChildren("config-file");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: WebserviceDescriptionType ElementName: xsd:string ElementType : wsdl-publish-location
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>wsdl-publish-location</code> element
    * @param wsdlPublishLocation the value for the element <code>wsdl-publish-location</code> 
    * @return the current instance of <code>WebserviceDescriptionType<T></code> 
    */
   public WebserviceDescriptionType<T> wsdlPublishLocation(String wsdlPublishLocation)
   {
      childNode.getOrCreate("wsdl-publish-location").text(wsdlPublishLocation);
      return this;
   }

   /**
    * Returns the <code>wsdl-publish-location</code> element
    * @return the node defined for the element <code>wsdl-publish-location</code> 
    */
   public String getWsdlPublishLocation()
   {
      return childNode.getTextValueForPatternName("wsdl-publish-location");
   }

   /**
    * Removes the <code>wsdl-publish-location</code> element 
    * @return the current instance of <code>WebserviceDescriptionType<T></code> 
    */
   public WebserviceDescriptionType<T> removeWsdlPublishLocation()
   {
      childNode.removeChildren("wsdl-publish-location");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: WebserviceDescriptionType ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>WebserviceDescriptionType<T></code> 
    */
   public WebserviceDescriptionType<T> id(String id)
   {
      childNode.attribute("id", id);
      return this;
   }

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
      public String getId()
   {
      return childNode.getAttribute("id");
   }

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>WebserviceDescriptionType<T></code> 
    */
   public WebserviceDescriptionType<T> removeId()
   {
      childNode.removeAttribute("id");
      return this;
   }
}
