package org.jboss.shrinkwrap.descriptor.impl.jbosscommon60; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.PortComponentRefType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.StubPropertyType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon60.StubPropertyTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.CallPropertyType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon60.CallPropertyTypeImpl;

/**
 * This class implements the <code> port-component-refType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class PortComponentRefTypeImpl<T> implements Child<T>, PortComponentRefType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public PortComponentRefTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public PortComponentRefTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PortComponentRefType ElementName: xsd:string ElementType : service-endpoint-interface
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>service-endpoint-interface</code> element
    * @param serviceEndpointInterface the value for the element <code>service-endpoint-interface</code> 
    * @return the current instance of <code>PortComponentRefType<T></code> 
    */
   public PortComponentRefType<T> serviceEndpointInterface(String serviceEndpointInterface)
   {
      childNode.getOrCreate("service-endpoint-interface").text(serviceEndpointInterface);
      return this;
   }

   /**
    * Returns the <code>service-endpoint-interface</code> element
    * @return the node defined for the element <code>service-endpoint-interface</code> 
    */
   public String getServiceEndpointInterface()
   {
      return childNode.getTextValueForPatternName("service-endpoint-interface");
   }

   /**
    * Removes the <code>service-endpoint-interface</code> element 
    * @return the current instance of <code>PortComponentRefType<T></code> 
    */
   public PortComponentRefType<T> removeServiceEndpointInterface()
   {
      childNode.removeChildren("service-endpoint-interface");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PortComponentRefType ElementName: xsd:string ElementType : port-qname
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>port-qname</code> element
    * @param portQname the value for the element <code>port-qname</code> 
    * @return the current instance of <code>PortComponentRefType<T></code> 
    */
   public PortComponentRefType<T> portQname(String portQname)
   {
      childNode.getOrCreate("port-qname").text(portQname);
      return this;
   }

   /**
    * Returns the <code>port-qname</code> element
    * @return the node defined for the element <code>port-qname</code> 
    */
   public String getPortQname()
   {
      return childNode.getTextValueForPatternName("port-qname");
   }

   /**
    * Removes the <code>port-qname</code> element 
    * @return the current instance of <code>PortComponentRefType<T></code> 
    */
   public PortComponentRefType<T> removePortQname()
   {
      childNode.removeChildren("port-qname");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PortComponentRefType ElementName: xsd:string ElementType : config-name
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>config-name</code> element
    * @param configName the value for the element <code>config-name</code> 
    * @return the current instance of <code>PortComponentRefType<T></code> 
    */
   public PortComponentRefType<T> configName(String configName)
   {
      childNode.getOrCreate("config-name").text(configName);
      return this;
   }

   /**
    * Returns the <code>config-name</code> element
    * @return the node defined for the element <code>config-name</code> 
    */
   public String getConfigName()
   {
      return childNode.getTextValueForPatternName("config-name");
   }

   /**
    * Removes the <code>config-name</code> element 
    * @return the current instance of <code>PortComponentRefType<T></code> 
    */
   public PortComponentRefType<T> removeConfigName()
   {
      childNode.removeChildren("config-name");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PortComponentRefType ElementName: xsd:string ElementType : config-file
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>config-file</code> element
    * @param configFile the value for the element <code>config-file</code> 
    * @return the current instance of <code>PortComponentRefType<T></code> 
    */
   public PortComponentRefType<T> configFile(String configFile)
   {
      childNode.getOrCreate("config-file").text(configFile);
      return this;
   }

   /**
    * Returns the <code>config-file</code> element
    * @return the node defined for the element <code>config-file</code> 
    */
   public String getConfigFile()
   {
      return childNode.getTextValueForPatternName("config-file");
   }

   /**
    * Removes the <code>config-file</code> element 
    * @return the current instance of <code>PortComponentRefType<T></code> 
    */
   public PortComponentRefType<T> removeConfigFile()
   {
      childNode.removeChildren("config-file");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PortComponentRefType ElementName: jboss:stub-propertyType ElementType : stub-property
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>stub-property</code> element will be created and returned.
    * Otherwise, the first existing <code>stub-property</code> element will be returned.
    * @return the instance defined for the element <code>stub-property</code> 
    */
   public StubPropertyType<PortComponentRefType<T>> getOrCreateStubProperty()
   {
      List<Node> nodeList = childNode.get("stub-property");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new StubPropertyTypeImpl<PortComponentRefType<T>>(this, "stub-property", childNode, nodeList.get(0));
      }
      return createStubProperty();
   }

   /**
    * Creates a new <code>stub-property</code> element 
    * @return the new created instance of <code>StubPropertyType<PortComponentRefType<T>></code> 
    */
   public StubPropertyType<PortComponentRefType<T>> createStubProperty()
   {
      return new StubPropertyTypeImpl<PortComponentRefType<T>>(this, "stub-property", childNode);
   }

   /**
    * Returns all <code>stub-property</code> elements
    * @return list of <code>stub-property</code> 
    */
   public List<StubPropertyType<PortComponentRefType<T>>> getAllStubProperty()
   {
      List<StubPropertyType<PortComponentRefType<T>>> list = new ArrayList<StubPropertyType<PortComponentRefType<T>>>();
      List<Node> nodeList = childNode.get("stub-property");
      for(Node node: nodeList)
      {
         StubPropertyType<PortComponentRefType<T>>  type = new StubPropertyTypeImpl<PortComponentRefType<T>>(this, "stub-property", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>stub-property</code> elements 
    * @return the current instance of <code>StubPropertyType<PortComponentRefType<T>></code> 
    */
   public PortComponentRefType<T> removeAllStubProperty()
   {
      childNode.removeChildren("stub-property");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PortComponentRefType ElementName: jboss:call-propertyType ElementType : call-property
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>call-property</code> element will be created and returned.
    * Otherwise, the first existing <code>call-property</code> element will be returned.
    * @return the instance defined for the element <code>call-property</code> 
    */
   public CallPropertyType<PortComponentRefType<T>> getOrCreateCallProperty()
   {
      List<Node> nodeList = childNode.get("call-property");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new CallPropertyTypeImpl<PortComponentRefType<T>>(this, "call-property", childNode, nodeList.get(0));
      }
      return createCallProperty();
   }

   /**
    * Creates a new <code>call-property</code> element 
    * @return the new created instance of <code>CallPropertyType<PortComponentRefType<T>></code> 
    */
   public CallPropertyType<PortComponentRefType<T>> createCallProperty()
   {
      return new CallPropertyTypeImpl<PortComponentRefType<T>>(this, "call-property", childNode);
   }

   /**
    * Returns all <code>call-property</code> elements
    * @return list of <code>call-property</code> 
    */
   public List<CallPropertyType<PortComponentRefType<T>>> getAllCallProperty()
   {
      List<CallPropertyType<PortComponentRefType<T>>> list = new ArrayList<CallPropertyType<PortComponentRefType<T>>>();
      List<Node> nodeList = childNode.get("call-property");
      for(Node node: nodeList)
      {
         CallPropertyType<PortComponentRefType<T>>  type = new CallPropertyTypeImpl<PortComponentRefType<T>>(this, "call-property", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>call-property</code> elements 
    * @return the current instance of <code>CallPropertyType<PortComponentRefType<T>></code> 
    */
   public PortComponentRefType<T> removeAllCallProperty()
   {
      childNode.removeChildren("call-property");
      return this;
   }
}
