package org.jboss.shrinkwrap.descriptor.impl.jbossdeployment10; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.SubDeploymentType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.FilterType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment10.FilterTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.DependenciesType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment10.DependenciesTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.ExclusionsType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment10.ExclusionsTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.ResourcesType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment10.ResourcesTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.TransformerSetType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment10.TransformerSetTypeImpl;

/**
 * This class implements the <code> subDeploymentType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class SubDeploymentTypeImpl<T> implements Child<T>, SubDeploymentType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public SubDeploymentTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public SubDeploymentTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: SubDeploymentType ElementName: jboss:filterType ElementType : exports
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>exports</code> element with the given value will be created.
    * Otherwise, the existing <code>exports</code> element will be returned.
    * @return  a new or existing instance of <code>FilterType<SubDeploymentType<T>></code> 
    */
   public FilterType<SubDeploymentType<T>> getOrCreateExports()
   {
      Node node = childNode.getOrCreate("exports");
      FilterType<SubDeploymentType<T>> exports = new FilterTypeImpl<SubDeploymentType<T>>(this, "exports", childNode, node);
      return exports;
   }

   /**
    * Removes the <code>exports</code> element 
    * @return the current instance of <code>SubDeploymentType<T></code> 
    */
   public SubDeploymentType<T> removeExports()
   {
      childNode.removeChildren("exports");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: SubDeploymentType ElementName: jboss:dependenciesType ElementType : dependencies
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>dependencies</code> element with the given value will be created.
    * Otherwise, the existing <code>dependencies</code> element will be returned.
    * @return  a new or existing instance of <code>DependenciesType<SubDeploymentType<T>></code> 
    */
   public DependenciesType<SubDeploymentType<T>> getOrCreateDependencies()
   {
      Node node = childNode.getOrCreate("dependencies");
      DependenciesType<SubDeploymentType<T>> dependencies = new DependenciesTypeImpl<SubDeploymentType<T>>(this, "dependencies", childNode, node);
      return dependencies;
   }

   /**
    * Removes the <code>dependencies</code> element 
    * @return the current instance of <code>SubDeploymentType<T></code> 
    */
   public SubDeploymentType<T> removeDependencies()
   {
      childNode.removeChildren("dependencies");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: SubDeploymentType ElementName: jboss:exclusionsType ElementType : exclusions
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>exclusions</code> element with the given value will be created.
    * Otherwise, the existing <code>exclusions</code> element will be returned.
    * @return  a new or existing instance of <code>ExclusionsType<SubDeploymentType<T>></code> 
    */
   public ExclusionsType<SubDeploymentType<T>> getOrCreateExclusions()
   {
      Node node = childNode.getOrCreate("exclusions");
      ExclusionsType<SubDeploymentType<T>> exclusions = new ExclusionsTypeImpl<SubDeploymentType<T>>(this, "exclusions", childNode, node);
      return exclusions;
   }

   /**
    * Removes the <code>exclusions</code> element 
    * @return the current instance of <code>SubDeploymentType<T></code> 
    */
   public SubDeploymentType<T> removeExclusions()
   {
      childNode.removeChildren("exclusions");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: SubDeploymentType ElementName: jboss:resourcesType ElementType : resources
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>resources</code> element with the given value will be created.
    * Otherwise, the existing <code>resources</code> element will be returned.
    * @return  a new or existing instance of <code>ResourcesType<SubDeploymentType<T>></code> 
    */
   public ResourcesType<SubDeploymentType<T>> getOrCreateResources()
   {
      Node node = childNode.getOrCreate("resources");
      ResourcesType<SubDeploymentType<T>> resources = new ResourcesTypeImpl<SubDeploymentType<T>>(this, "resources", childNode, node);
      return resources;
   }

   /**
    * Removes the <code>resources</code> element 
    * @return the current instance of <code>SubDeploymentType<T></code> 
    */
   public SubDeploymentType<T> removeResources()
   {
      childNode.removeChildren("resources");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: SubDeploymentType ElementName: jboss:transformerSetType ElementType : transformers
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>transformers</code> element with the given value will be created.
    * Otherwise, the existing <code>transformers</code> element will be returned.
    * @return  a new or existing instance of <code>TransformerSetType<SubDeploymentType<T>></code> 
    */
   public TransformerSetType<SubDeploymentType<T>> getOrCreateTransformers()
   {
      Node node = childNode.getOrCreate("transformers");
      TransformerSetType<SubDeploymentType<T>> transformers = new TransformerSetTypeImpl<SubDeploymentType<T>>(this, "transformers", childNode, node);
      return transformers;
   }

   /**
    * Removes the <code>transformers</code> element 
    * @return the current instance of <code>SubDeploymentType<T></code> 
    */
   public SubDeploymentType<T> removeTransformers()
   {
      childNode.removeChildren("transformers");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: SubDeploymentType ElementName: xsd:string ElementType : name
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>name</code> attribute
    * @param name the value for the attribute <code>name</code> 
    * @return the current instance of <code>SubDeploymentType<T></code> 
    */
   public SubDeploymentType<T> name(String name)
   {
      childNode.attribute("name", name);
      return this;
   }

   /**
    * Returns the <code>name</code> attribute
    * @return the value defined for the attribute <code>name</code> 
    */
      public String getName()
   {
      return childNode.getAttribute("name");
   }

   /**
    * Removes the <code>name</code> attribute 
    * @return the current instance of <code>SubDeploymentType<T></code> 
    */
   public SubDeploymentType<T> removeName()
   {
      childNode.removeAttribute("name");
      return this;
   }
}
