package org.jboss.shrinkwrap.descriptor.impl.jbossdeployment12; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment12.DependenciesType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment12.ModuleDependencyType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment12.ModuleDependencyTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment12.SystemDependencyType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment12.SystemDependencyTypeImpl;

/**
 * This class implements the <code> dependenciesType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class DependenciesTypeImpl<T> implements Child<T>, DependenciesType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public DependenciesTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public DependenciesTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: DependenciesType ElementName: jboss:moduleDependencyType ElementType : module
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>module</code> element will be created and returned.
    * Otherwise, the first existing <code>module</code> element will be returned.
    * @return the instance defined for the element <code>module</code> 
    */
   public ModuleDependencyType<DependenciesType<T>> getOrCreateModule()
   {
      List<Node> nodeList = childNode.get("module");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new ModuleDependencyTypeImpl<DependenciesType<T>>(this, "module", childNode, nodeList.get(0));
      }
      return createModule();
   }

   /**
    * Creates a new <code>module</code> element 
    * @return the new created instance of <code>ModuleDependencyType<DependenciesType<T>></code> 
    */
   public ModuleDependencyType<DependenciesType<T>> createModule()
   {
      return new ModuleDependencyTypeImpl<DependenciesType<T>>(this, "module", childNode);
   }

   /**
    * Returns all <code>module</code> elements
    * @return list of <code>module</code> 
    */
   public List<ModuleDependencyType<DependenciesType<T>>> getAllModule()
   {
      List<ModuleDependencyType<DependenciesType<T>>> list = new ArrayList<ModuleDependencyType<DependenciesType<T>>>();
      List<Node> nodeList = childNode.get("module");
      for(Node node: nodeList)
      {
         ModuleDependencyType<DependenciesType<T>>  type = new ModuleDependencyTypeImpl<DependenciesType<T>>(this, "module", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>module</code> elements 
    * @return the current instance of <code>ModuleDependencyType<DependenciesType<T>></code> 
    */
   public DependenciesType<T> removeAllModule()
   {
      childNode.removeChildren("module");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: DependenciesType ElementName: jboss:systemDependencyType ElementType : system
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>system</code> element will be created and returned.
    * Otherwise, the first existing <code>system</code> element will be returned.
    * @return the instance defined for the element <code>system</code> 
    */
   public SystemDependencyType<DependenciesType<T>> getOrCreateSystem()
   {
      List<Node> nodeList = childNode.get("system");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new SystemDependencyTypeImpl<DependenciesType<T>>(this, "system", childNode, nodeList.get(0));
      }
      return createSystem();
   }

   /**
    * Creates a new <code>system</code> element 
    * @return the new created instance of <code>SystemDependencyType<DependenciesType<T>></code> 
    */
   public SystemDependencyType<DependenciesType<T>> createSystem()
   {
      return new SystemDependencyTypeImpl<DependenciesType<T>>(this, "system", childNode);
   }

   /**
    * Returns all <code>system</code> elements
    * @return list of <code>system</code> 
    */
   public List<SystemDependencyType<DependenciesType<T>>> getAllSystem()
   {
      List<SystemDependencyType<DependenciesType<T>>> list = new ArrayList<SystemDependencyType<DependenciesType<T>>>();
      List<Node> nodeList = childNode.get("system");
      for(Node node: nodeList)
      {
         SystemDependencyType<DependenciesType<T>>  type = new SystemDependencyTypeImpl<DependenciesType<T>>(this, "system", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>system</code> elements 
    * @return the current instance of <code>SystemDependencyType<DependenciesType<T>></code> 
    */
   public DependenciesType<T> removeAllSystem()
   {
      childNode.removeChildren("system");
      return this;
   }
}
