package org.jboss.shrinkwrap.descriptor.impl.jbossdeployment13; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.ExcludeSubsystemsType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.SubsystemType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment13.SubsystemTypeImpl;

/**
 * This class implements the <code> exclude-subsystemsType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class ExcludeSubsystemsTypeImpl<T> implements Child<T>, ExcludeSubsystemsType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public ExcludeSubsystemsTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public ExcludeSubsystemsTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ExcludeSubsystemsType ElementName: jboss:subsystemType ElementType : subsystem
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>subsystem</code> element will be created and returned.
    * Otherwise, the first existing <code>subsystem</code> element will be returned.
    * @return the instance defined for the element <code>subsystem</code> 
    */
   public SubsystemType<ExcludeSubsystemsType<T>> getOrCreateSubsystem()
   {
      List<Node> nodeList = childNode.get("subsystem");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new SubsystemTypeImpl<ExcludeSubsystemsType<T>>(this, "subsystem", childNode, nodeList.get(0));
      }
      return createSubsystem();
   }

   /**
    * Creates a new <code>subsystem</code> element 
    * @return the new created instance of <code>SubsystemType<ExcludeSubsystemsType<T>></code> 
    */
   public SubsystemType<ExcludeSubsystemsType<T>> createSubsystem()
   {
      return new SubsystemTypeImpl<ExcludeSubsystemsType<T>>(this, "subsystem", childNode);
   }

   /**
    * Returns all <code>subsystem</code> elements
    * @return list of <code>subsystem</code> 
    */
   public List<SubsystemType<ExcludeSubsystemsType<T>>> getAllSubsystem()
   {
      List<SubsystemType<ExcludeSubsystemsType<T>>> list = new ArrayList<SubsystemType<ExcludeSubsystemsType<T>>>();
      List<Node> nodeList = childNode.get("subsystem");
      for(Node node: nodeList)
      {
         SubsystemType<ExcludeSubsystemsType<T>>  type = new SubsystemTypeImpl<ExcludeSubsystemsType<T>>(this, "subsystem", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>subsystem</code> elements 
    * @return the current instance of <code>SubsystemType<ExcludeSubsystemsType<T>></code> 
    */
   public ExcludeSubsystemsType<T> removeAllSubsystem()
   {
      childNode.removeChildren("subsystem");
      return this;
   }
}
