package org.jboss.shrinkwrap.descriptor.impl.jbossdeployment13; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.FilterType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.PathSpecType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment13.PathSpecTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.PathSpecType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment13.PathSpecTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.PathSetType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment13.PathSetTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.PathSetType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment13.PathSetTypeImpl;

/**
 * This class implements the <code> filterType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class FilterTypeImpl<T> implements Child<T>, FilterType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public FilterTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public FilterTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: FilterType ElementName: jboss:pathSpecType ElementType : include
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>include</code> element will be created and returned.
    * Otherwise, the first existing <code>include</code> element will be returned.
    * @return the instance defined for the element <code>include</code> 
    */
   public PathSpecType<FilterType<T>> getOrCreateInclude()
   {
      List<Node> nodeList = childNode.get("include");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new PathSpecTypeImpl<FilterType<T>>(this, "include", childNode, nodeList.get(0));
      }
      return createInclude();
   }

   /**
    * Creates a new <code>include</code> element 
    * @return the new created instance of <code>PathSpecType<FilterType<T>></code> 
    */
   public PathSpecType<FilterType<T>> createInclude()
   {
      return new PathSpecTypeImpl<FilterType<T>>(this, "include", childNode);
   }

   /**
    * Returns all <code>include</code> elements
    * @return list of <code>include</code> 
    */
   public List<PathSpecType<FilterType<T>>> getAllInclude()
   {
      List<PathSpecType<FilterType<T>>> list = new ArrayList<PathSpecType<FilterType<T>>>();
      List<Node> nodeList = childNode.get("include");
      for(Node node: nodeList)
      {
         PathSpecType<FilterType<T>>  type = new PathSpecTypeImpl<FilterType<T>>(this, "include", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>include</code> elements 
    * @return the current instance of <code>PathSpecType<FilterType<T>></code> 
    */
   public FilterType<T> removeAllInclude()
   {
      childNode.removeChildren("include");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: FilterType ElementName: jboss:pathSpecType ElementType : exclude
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>exclude</code> element will be created and returned.
    * Otherwise, the first existing <code>exclude</code> element will be returned.
    * @return the instance defined for the element <code>exclude</code> 
    */
   public PathSpecType<FilterType<T>> getOrCreateExclude()
   {
      List<Node> nodeList = childNode.get("exclude");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new PathSpecTypeImpl<FilterType<T>>(this, "exclude", childNode, nodeList.get(0));
      }
      return createExclude();
   }

   /**
    * Creates a new <code>exclude</code> element 
    * @return the new created instance of <code>PathSpecType<FilterType<T>></code> 
    */
   public PathSpecType<FilterType<T>> createExclude()
   {
      return new PathSpecTypeImpl<FilterType<T>>(this, "exclude", childNode);
   }

   /**
    * Returns all <code>exclude</code> elements
    * @return list of <code>exclude</code> 
    */
   public List<PathSpecType<FilterType<T>>> getAllExclude()
   {
      List<PathSpecType<FilterType<T>>> list = new ArrayList<PathSpecType<FilterType<T>>>();
      List<Node> nodeList = childNode.get("exclude");
      for(Node node: nodeList)
      {
         PathSpecType<FilterType<T>>  type = new PathSpecTypeImpl<FilterType<T>>(this, "exclude", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>exclude</code> elements 
    * @return the current instance of <code>PathSpecType<FilterType<T>></code> 
    */
   public FilterType<T> removeAllExclude()
   {
      childNode.removeChildren("exclude");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: FilterType ElementName: jboss:pathSetType ElementType : include-set
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>include-set</code> element will be created and returned.
    * Otherwise, the first existing <code>include-set</code> element will be returned.
    * @return the instance defined for the element <code>include-set</code> 
    */
   public PathSetType<FilterType<T>> getOrCreateIncludeSet()
   {
      List<Node> nodeList = childNode.get("include-set");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new PathSetTypeImpl<FilterType<T>>(this, "include-set", childNode, nodeList.get(0));
      }
      return createIncludeSet();
   }

   /**
    * Creates a new <code>include-set</code> element 
    * @return the new created instance of <code>PathSetType<FilterType<T>></code> 
    */
   public PathSetType<FilterType<T>> createIncludeSet()
   {
      return new PathSetTypeImpl<FilterType<T>>(this, "include-set", childNode);
   }

   /**
    * Returns all <code>include-set</code> elements
    * @return list of <code>include-set</code> 
    */
   public List<PathSetType<FilterType<T>>> getAllIncludeSet()
   {
      List<PathSetType<FilterType<T>>> list = new ArrayList<PathSetType<FilterType<T>>>();
      List<Node> nodeList = childNode.get("include-set");
      for(Node node: nodeList)
      {
         PathSetType<FilterType<T>>  type = new PathSetTypeImpl<FilterType<T>>(this, "include-set", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>include-set</code> elements 
    * @return the current instance of <code>PathSetType<FilterType<T>></code> 
    */
   public FilterType<T> removeAllIncludeSet()
   {
      childNode.removeChildren("include-set");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: FilterType ElementName: jboss:pathSetType ElementType : exclude-set
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>exclude-set</code> element will be created and returned.
    * Otherwise, the first existing <code>exclude-set</code> element will be returned.
    * @return the instance defined for the element <code>exclude-set</code> 
    */
   public PathSetType<FilterType<T>> getOrCreateExcludeSet()
   {
      List<Node> nodeList = childNode.get("exclude-set");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new PathSetTypeImpl<FilterType<T>>(this, "exclude-set", childNode, nodeList.get(0));
      }
      return createExcludeSet();
   }

   /**
    * Creates a new <code>exclude-set</code> element 
    * @return the new created instance of <code>PathSetType<FilterType<T>></code> 
    */
   public PathSetType<FilterType<T>> createExcludeSet()
   {
      return new PathSetTypeImpl<FilterType<T>>(this, "exclude-set", childNode);
   }

   /**
    * Returns all <code>exclude-set</code> elements
    * @return list of <code>exclude-set</code> 
    */
   public List<PathSetType<FilterType<T>>> getAllExcludeSet()
   {
      List<PathSetType<FilterType<T>>> list = new ArrayList<PathSetType<FilterType<T>>>();
      List<Node> nodeList = childNode.get("exclude-set");
      for(Node node: nodeList)
      {
         PathSetType<FilterType<T>>  type = new PathSetTypeImpl<FilterType<T>>(this, "exclude-set", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>exclude-set</code> elements 
    * @return the current instance of <code>PathSetType<FilterType<T>></code> 
    */
   public FilterType<T> removeAllExcludeSet()
   {
      childNode.removeChildren("exclude-set");
      return this;
   }
}
