package org.jboss.shrinkwrap.descriptor.impl.jbossdeployment13; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.PathSetType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.PathType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment13.PathTypeImpl;

/**
 * This class implements the <code> pathSetType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class PathSetTypeImpl<T> implements Child<T>, PathSetType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public PathSetTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public PathSetTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PathSetType ElementName: jboss:pathType ElementType : path
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>path</code> element will be created and returned.
    * Otherwise, the first existing <code>path</code> element will be returned.
    * @return the instance defined for the element <code>path</code> 
    */
   public PathType<PathSetType<T>> getOrCreatePath()
   {
      List<Node> nodeList = childNode.get("path");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new PathTypeImpl<PathSetType<T>>(this, "path", childNode, nodeList.get(0));
      }
      return createPath();
   }

   /**
    * Creates a new <code>path</code> element 
    * @return the new created instance of <code>PathType<PathSetType<T>></code> 
    */
   public PathType<PathSetType<T>> createPath()
   {
      return new PathTypeImpl<PathSetType<T>>(this, "path", childNode);
   }

   /**
    * Returns all <code>path</code> elements
    * @return list of <code>path</code> 
    */
   public List<PathType<PathSetType<T>>> getAllPath()
   {
      List<PathType<PathSetType<T>>> list = new ArrayList<PathType<PathSetType<T>>>();
      List<Node> nodeList = childNode.get("path");
      for(Node node: nodeList)
      {
         PathType<PathSetType<T>>  type = new PathTypeImpl<PathSetType<T>>(this, "path", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>path</code> elements 
    * @return the current instance of <code>PathType<PathSetType<T>></code> 
    */
   public PathSetType<T> removeAllPath()
   {
      childNode.removeChildren("path");
      return this;
   }
}
