package org.jboss.shrinkwrap.descriptor.impl.jbossdeployment13; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.SubDeploymentType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.ModuleAliasType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment13.ModuleAliasTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.FilterType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment13.FilterTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.DependenciesType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment13.DependenciesTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.ExclusionsType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment13.ExclusionsTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.ResourcesType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment13.ResourcesTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.TransformerSetType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment13.TransformerSetTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.LocalLast;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment13.LocalLastImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.ExcludeSubsystemsType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment13.ExcludeSubsystemsTypeImpl;

/**
 * This class implements the <code> subDeploymentType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class SubDeploymentTypeImpl<T> implements Child<T>, SubDeploymentType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public SubDeploymentTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public SubDeploymentTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: SubDeploymentType ElementName: jboss:moduleAliasType ElementType : module-alias
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>module-alias</code> element with the given value will be created.
    * Otherwise, the existing <code>module-alias</code> element will be returned.
    * @return  a new or existing instance of <code>ModuleAliasType<SubDeploymentType<T>></code> 
    */
   public ModuleAliasType<SubDeploymentType<T>> getOrCreateModuleAlias()
   {
      Node node = childNode.getOrCreate("module-alias");
      ModuleAliasType<SubDeploymentType<T>> moduleAlias = new ModuleAliasTypeImpl<SubDeploymentType<T>>(this, "module-alias", childNode, node);
      return moduleAlias;
   }

   /**
    * Removes the <code>module-alias</code> element 
    * @return the current instance of <code>SubDeploymentType<T></code> 
    */
   public SubDeploymentType<T> removeModuleAlias()
   {
      childNode.removeChildren("module-alias");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: SubDeploymentType ElementName: jboss:filterType ElementType : exports
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>exports</code> element with the given value will be created.
    * Otherwise, the existing <code>exports</code> element will be returned.
    * @return  a new or existing instance of <code>FilterType<SubDeploymentType<T>></code> 
    */
   public FilterType<SubDeploymentType<T>> getOrCreateExports()
   {
      Node node = childNode.getOrCreate("exports");
      FilterType<SubDeploymentType<T>> exports = new FilterTypeImpl<SubDeploymentType<T>>(this, "exports", childNode, node);
      return exports;
   }

   /**
    * Removes the <code>exports</code> element 
    * @return the current instance of <code>SubDeploymentType<T></code> 
    */
   public SubDeploymentType<T> removeExports()
   {
      childNode.removeChildren("exports");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: SubDeploymentType ElementName: jboss:dependenciesType ElementType : dependencies
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>dependencies</code> element with the given value will be created.
    * Otherwise, the existing <code>dependencies</code> element will be returned.
    * @return  a new or existing instance of <code>DependenciesType<SubDeploymentType<T>></code> 
    */
   public DependenciesType<SubDeploymentType<T>> getOrCreateDependencies()
   {
      Node node = childNode.getOrCreate("dependencies");
      DependenciesType<SubDeploymentType<T>> dependencies = new DependenciesTypeImpl<SubDeploymentType<T>>(this, "dependencies", childNode, node);
      return dependencies;
   }

   /**
    * Removes the <code>dependencies</code> element 
    * @return the current instance of <code>SubDeploymentType<T></code> 
    */
   public SubDeploymentType<T> removeDependencies()
   {
      childNode.removeChildren("dependencies");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: SubDeploymentType ElementName: jboss:exclusionsType ElementType : exclusions
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>exclusions</code> element with the given value will be created.
    * Otherwise, the existing <code>exclusions</code> element will be returned.
    * @return  a new or existing instance of <code>ExclusionsType<SubDeploymentType<T>></code> 
    */
   public ExclusionsType<SubDeploymentType<T>> getOrCreateExclusions()
   {
      Node node = childNode.getOrCreate("exclusions");
      ExclusionsType<SubDeploymentType<T>> exclusions = new ExclusionsTypeImpl<SubDeploymentType<T>>(this, "exclusions", childNode, node);
      return exclusions;
   }

   /**
    * Removes the <code>exclusions</code> element 
    * @return the current instance of <code>SubDeploymentType<T></code> 
    */
   public SubDeploymentType<T> removeExclusions()
   {
      childNode.removeChildren("exclusions");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: SubDeploymentType ElementName: jboss:resourcesType ElementType : resources
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>resources</code> element with the given value will be created.
    * Otherwise, the existing <code>resources</code> element will be returned.
    * @return  a new or existing instance of <code>ResourcesType<SubDeploymentType<T>></code> 
    */
   public ResourcesType<SubDeploymentType<T>> getOrCreateResources()
   {
      Node node = childNode.getOrCreate("resources");
      ResourcesType<SubDeploymentType<T>> resources = new ResourcesTypeImpl<SubDeploymentType<T>>(this, "resources", childNode, node);
      return resources;
   }

   /**
    * Removes the <code>resources</code> element 
    * @return the current instance of <code>SubDeploymentType<T></code> 
    */
   public SubDeploymentType<T> removeResources()
   {
      childNode.removeChildren("resources");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: SubDeploymentType ElementName: jboss:transformerSetType ElementType : transformers
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>transformers</code> element with the given value will be created.
    * Otherwise, the existing <code>transformers</code> element will be returned.
    * @return  a new or existing instance of <code>TransformerSetType<SubDeploymentType<T>></code> 
    */
   public TransformerSetType<SubDeploymentType<T>> getOrCreateTransformers()
   {
      Node node = childNode.getOrCreate("transformers");
      TransformerSetType<SubDeploymentType<T>> transformers = new TransformerSetTypeImpl<SubDeploymentType<T>>(this, "transformers", childNode, node);
      return transformers;
   }

   /**
    * Removes the <code>transformers</code> element 
    * @return the current instance of <code>SubDeploymentType<T></code> 
    */
   public SubDeploymentType<T> removeTransformers()
   {
      childNode.removeChildren("transformers");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: SubDeploymentType ElementName: jboss:localLast ElementType : local-last
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>local-last</code> element with the given value will be created.
    * Otherwise, the existing <code>local-last</code> element will be returned.
    * @return  a new or existing instance of <code>LocalLast<SubDeploymentType<T>></code> 
    */
   public LocalLast<SubDeploymentType<T>> getOrCreateLocalLast()
   {
      Node node = childNode.getOrCreate("local-last");
      LocalLast<SubDeploymentType<T>> localLast = new LocalLastImpl<SubDeploymentType<T>>(this, "local-last", childNode, node);
      return localLast;
   }

   /**
    * Removes the <code>local-last</code> element 
    * @return the current instance of <code>SubDeploymentType<T></code> 
    */
   public SubDeploymentType<T> removeLocalLast()
   {
      childNode.removeChildren("local-last");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: SubDeploymentType ElementName: jboss:exclude-subsystemsType ElementType : exclude-subsystems
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>exclude-subsystems</code> element with the given value will be created.
    * Otherwise, the existing <code>exclude-subsystems</code> element will be returned.
    * @return  a new or existing instance of <code>ExcludeSubsystemsType<SubDeploymentType<T>></code> 
    */
   public ExcludeSubsystemsType<SubDeploymentType<T>> getOrCreateExcludeSubsystems()
   {
      Node node = childNode.getOrCreate("exclude-subsystems");
      ExcludeSubsystemsType<SubDeploymentType<T>> excludeSubsystems = new ExcludeSubsystemsTypeImpl<SubDeploymentType<T>>(this, "exclude-subsystems", childNode, node);
      return excludeSubsystems;
   }

   /**
    * Removes the <code>exclude-subsystems</code> element 
    * @return the current instance of <code>SubDeploymentType<T></code> 
    */
   public SubDeploymentType<T> removeExcludeSubsystems()
   {
      childNode.removeChildren("exclude-subsystems");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: SubDeploymentType ElementName: xsd:string ElementType : name
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>name</code> attribute
    * @param name the value for the attribute <code>name</code> 
    * @return the current instance of <code>SubDeploymentType<T></code> 
    */
   public SubDeploymentType<T> name(String name)
   {
      childNode.attribute("name", name);
      return this;
   }

   /**
    * Returns the <code>name</code> attribute
    * @return the value defined for the attribute <code>name</code> 
    */
      public String getName()
   {
      return childNode.getAttribute("name");
   }

   /**
    * Removes the <code>name</code> attribute 
    * @return the current instance of <code>SubDeploymentType<T></code> 
    */
   public SubDeploymentType<T> removeName()
   {
      childNode.removeAttribute("name");
      return this;
   }
}
