package org.jboss.shrinkwrap.descriptor.impl.jbossmodule13; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.ResourceType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.FilterType;
import org.jboss.shrinkwrap.descriptor.impl.jbossmodule13.FilterTypeImpl;

/**
 * This class implements the <code> resourceType </code> xsd type 
 * @author <a href="mailto:tcrawley@redhat.com">Toby Crawley</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class ResourceTypeImpl<T> implements Child<T>, ResourceType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public ResourceTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public ResourceTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ResourceType ElementName: jboss:filterType ElementType : filter
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>filter</code> element with the given value will be created.
    * Otherwise, the existing <code>filter</code> element will be returned.
    * @return  a new or existing instance of <code>FilterType<ResourceType<T>></code> 
    */
   public FilterType<ResourceType<T>> getOrCreateFilter()
   {
      Node node = childNode.getOrCreate("filter");
      FilterType<ResourceType<T>> filter = new FilterTypeImpl<ResourceType<T>>(this, "filter", childNode, node);
      return filter;
   }

   /**
    * Removes the <code>filter</code> element 
    * @return the current instance of <code>ResourceType<T></code> 
    */
   public ResourceType<T> removeFilter()
   {
      childNode.removeChildren("filter");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ResourceType ElementName: xsd:string ElementType : name
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>name</code> attribute
    * @param name the value for the attribute <code>name</code> 
    * @return the current instance of <code>ResourceType<T></code> 
    */
   public ResourceType<T> name(String name)
   {
      childNode.attribute("name", name);
      return this;
   }

   /**
    * Returns the <code>name</code> attribute
    * @return the value defined for the attribute <code>name</code> 
    */
      public String getName()
   {
      return childNode.getAttribute("name");
   }

   /**
    * Removes the <code>name</code> attribute 
    * @return the current instance of <code>ResourceType<T></code> 
    */
   public ResourceType<T> removeName()
   {
      childNode.removeAttribute("name");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ResourceType ElementName: xsd:string ElementType : path
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>path</code> attribute
    * @param path the value for the attribute <code>path</code> 
    * @return the current instance of <code>ResourceType<T></code> 
    */
   public ResourceType<T> path(String path)
   {
      childNode.attribute("path", path);
      return this;
   }

   /**
    * Returns the <code>path</code> attribute
    * @return the value defined for the attribute <code>path</code> 
    */
      public String getPath()
   {
      return childNode.getAttribute("path");
   }

   /**
    * Removes the <code>path</code> attribute 
    * @return the current instance of <code>ResourceType<T></code> 
    */
   public ResourceType<T> removePath()
   {
      childNode.removeAttribute("path");
      return this;
   }
}
