package org.jboss.shrinkwrap.descriptor.impl.jbossmodule15; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule15.ArtifactType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule15.FilterType;
import org.jboss.shrinkwrap.descriptor.impl.jbossmodule15.FilterTypeImpl;

/**
 * This class implements the <code> artifactType </code> xsd type 
 * @author <a href="mailto:tcrawley@redhat.com">Toby Crawley</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class ArtifactTypeImpl<T> implements Child<T>, ArtifactType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public ArtifactTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public ArtifactTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ArtifactType ElementName: jboss:filterType ElementType : filter
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>filter</code> element with the given value will be created.
    * Otherwise, the existing <code>filter</code> element will be returned.
    * @return  a new or existing instance of <code>FilterType<ArtifactType<T>></code> 
    */
   public FilterType<ArtifactType<T>> getOrCreateFilter()
   {
      Node node = childNode.getOrCreate("filter");
      FilterType<ArtifactType<T>> filter = new FilterTypeImpl<ArtifactType<T>>(this, "filter", childNode, node);
      return filter;
   }

   /**
    * Removes the <code>filter</code> element 
    * @return the current instance of <code>ArtifactType<T></code> 
    */
   public ArtifactType<T> removeFilter()
   {
      childNode.removeChildren("filter");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ArtifactType ElementName: xsd:string ElementType : name
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>name</code> attribute
    * @param name the value for the attribute <code>name</code> 
    * @return the current instance of <code>ArtifactType<T></code> 
    */
   public ArtifactType<T> name(String name)
   {
      childNode.attribute("name", name);
      return this;
   }

   /**
    * Returns the <code>name</code> attribute
    * @return the value defined for the attribute <code>name</code> 
    */
      public String getName()
   {
      return childNode.getAttribute("name");
   }

   /**
    * Removes the <code>name</code> attribute 
    * @return the current instance of <code>ArtifactType<T></code> 
    */
   public ArtifactType<T> removeName()
   {
      childNode.removeAttribute("name");
      return this;
   }
}
