package org.jboss.shrinkwrap.descriptor.impl.jbossweb60; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.AnnotationType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.ServletSecurityType;
import org.jboss.shrinkwrap.descriptor.impl.jbossweb60.ServletSecurityTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.RunAsType;
import org.jboss.shrinkwrap.descriptor.impl.jbossweb60.RunAsTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.MultipartConfigType;
import org.jboss.shrinkwrap.descriptor.impl.jbossweb60.MultipartConfigTypeImpl;

/**
 * This class implements the <code> annotationType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class AnnotationTypeImpl<T> implements Child<T>, AnnotationType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public AnnotationTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public AnnotationTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: AnnotationType ElementName: xsd:token ElementType : class-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>class-name</code> element
    * @param className the value for the element <code>class-name</code> 
    * @return the current instance of <code>AnnotationType<T></code> 
    */
   public AnnotationType<T> className(String className)
   {
      childNode.getOrCreate("class-name").text(className);
      return this;
   }

   /**
    * Returns the <code>class-name</code> element
    * @return the node defined for the element <code>class-name</code> 
    */
   public String getClassName()
   {
      return childNode.getTextValueForPatternName("class-name");
   }

   /**
    * Removes the <code>class-name</code> element 
    * @return the current instance of <code>AnnotationType<T></code> 
    */
   public AnnotationType<T> removeClassName()
   {
      childNode.removeChildren("class-name");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: AnnotationType ElementName: jboss:servlet-securityType ElementType : servlet-security
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>servlet-security</code> element with the given value will be created.
    * Otherwise, the existing <code>servlet-security</code> element will be returned.
    * @return  a new or existing instance of <code>ServletSecurityType<AnnotationType<T>></code> 
    */
   public ServletSecurityType<AnnotationType<T>> getOrCreateServletSecurity()
   {
      Node node = childNode.getOrCreate("servlet-security");
      ServletSecurityType<AnnotationType<T>> servletSecurity = new ServletSecurityTypeImpl<AnnotationType<T>>(this, "servlet-security", childNode, node);
      return servletSecurity;
   }

   /**
    * Removes the <code>servlet-security</code> element 
    * @return the current instance of <code>AnnotationType<T></code> 
    */
   public AnnotationType<T> removeServletSecurity()
   {
      childNode.removeChildren("servlet-security");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: AnnotationType ElementName: jboss:run-asType ElementType : run-as
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>run-as</code> element with the given value will be created.
    * Otherwise, the existing <code>run-as</code> element will be returned.
    * @return  a new or existing instance of <code>RunAsType<AnnotationType<T>></code> 
    */
   public RunAsType<AnnotationType<T>> getOrCreateRunAs()
   {
      Node node = childNode.getOrCreate("run-as");
      RunAsType<AnnotationType<T>> runAs = new RunAsTypeImpl<AnnotationType<T>>(this, "run-as", childNode, node);
      return runAs;
   }

   /**
    * Removes the <code>run-as</code> element 
    * @return the current instance of <code>AnnotationType<T></code> 
    */
   public AnnotationType<T> removeRunAs()
   {
      childNode.removeChildren("run-as");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: AnnotationType ElementName: jboss:multipart-configType ElementType : multipart-config
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>multipart-config</code> element with the given value will be created.
    * Otherwise, the existing <code>multipart-config</code> element will be returned.
    * @return  a new or existing instance of <code>MultipartConfigType<AnnotationType<T>></code> 
    */
   public MultipartConfigType<AnnotationType<T>> getOrCreateMultipartConfig()
   {
      Node node = childNode.getOrCreate("multipart-config");
      MultipartConfigType<AnnotationType<T>> multipartConfig = new MultipartConfigTypeImpl<AnnotationType<T>>(this, "multipart-config", childNode, node);
      return multipartConfig;
   }

   /**
    * Removes the <code>multipart-config</code> element 
    * @return the current instance of <code>AnnotationType<T></code> 
    */
   public AnnotationType<T> removeMultipartConfig()
   {
      childNode.removeChildren("multipart-config");
      return this;
   }
}
