package org.jboss.shrinkwrap.descriptor.impl.jbossweb60; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.PassivationConfigType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.javaee6.GenericBooleanType;

/**
 * This class implements the <code> passivation-configType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class PassivationConfigTypeImpl<T> implements Child<T>, PassivationConfigType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public PassivationConfigTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public PassivationConfigTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PassivationConfigType ElementName: javaee:generic-booleanType ElementType : use-session-passivation
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: true isDataType: false
   // --------------------------------------------------------------------------------------------------------||
   /**
    * Sets the <code>use-session-passivation</code> element
    * @param useSessionPassivation the value for the element <code>use-session-passivation</code> 
    * @return the current instance of <code>PassivationConfigType<T></code> 
    */
   public PassivationConfigType<T> useSessionPassivation(GenericBooleanType useSessionPassivation)
   {
      childNode.getOrCreate("use-session-passivation").text(useSessionPassivation);
      return this;
   }
   /**
    * Sets the <code>use-session-passivation</code> element
    * @param useSessionPassivation the value for the element <code>use-session-passivation</code> 
    * @return the current instance of <code>PassivationConfigType<T></code> 
    */
   public PassivationConfigType<T> useSessionPassivation(String useSessionPassivation)
   {
      childNode.getOrCreate("use-session-passivation").text(useSessionPassivation);
      return this;
   }

   /**
    * Returns the <code>use-session-passivation</code> element
    * @return the value found for the element <code>use-session-passivation</code> 
    */
   public GenericBooleanType getUseSessionPassivation()
   {
      return GenericBooleanType.getFromStringValue(childNode.getTextValueForPatternName("use-session-passivation"));
   }

   /**
    * Returns the <code>use-session-passivation</code> element
    * @return the value found for the element <code>use-session-passivation</code> 
    */
   public String  getUseSessionPassivationAsString()
   {
      return childNode.getTextValueForPatternName("use-session-passivation");
   }

   /**
    * Removes the <code>use-session-passivation</code> attribute 
    * @return the current instance of <code>PassivationConfigType<T></code> 
    */
   public PassivationConfigType<T> removeUseSessionPassivation()
   {
      childNode.removeAttribute("use-session-passivation");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PassivationConfigType ElementName: xsd:integer ElementType : passivation-min-idle-time
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>passivation-min-idle-time</code> element
    * @param passivationMinIdleTime the value for the element <code>passivation-min-idle-time</code> 
    * @return the current instance of <code>PassivationConfigType<T></code> 
    */
   public PassivationConfigType<T> passivationMinIdleTime(Integer passivationMinIdleTime)
   {
      childNode.getOrCreate("passivation-min-idle-time").text(passivationMinIdleTime);
      return this;
   }

   /**
    * Returns the <code>passivation-min-idle-time</code> element
    * @return the node defined for the element <code>passivation-min-idle-time</code> 
    */
   public Integer getPassivationMinIdleTime()
   {
      if (childNode.getTextValueForPatternName("passivation-min-idle-time") != null && !childNode.getTextValueForPatternName("passivation-min-idle-time").equals("null")) {
         return Integer.valueOf(childNode.getTextValueForPatternName("passivation-min-idle-time"));
      }
      return null;
   }

   /**
    * Removes the <code>passivation-min-idle-time</code> element 
    * @return the current instance of <code>PassivationConfigType<T></code> 
    */
   public PassivationConfigType<T> removePassivationMinIdleTime()
   {
      childNode.removeChildren("passivation-min-idle-time");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PassivationConfigType ElementName: xsd:integer ElementType : passivation-max-idle-time
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>passivation-max-idle-time</code> element
    * @param passivationMaxIdleTime the value for the element <code>passivation-max-idle-time</code> 
    * @return the current instance of <code>PassivationConfigType<T></code> 
    */
   public PassivationConfigType<T> passivationMaxIdleTime(Integer passivationMaxIdleTime)
   {
      childNode.getOrCreate("passivation-max-idle-time").text(passivationMaxIdleTime);
      return this;
   }

   /**
    * Returns the <code>passivation-max-idle-time</code> element
    * @return the node defined for the element <code>passivation-max-idle-time</code> 
    */
   public Integer getPassivationMaxIdleTime()
   {
      if (childNode.getTextValueForPatternName("passivation-max-idle-time") != null && !childNode.getTextValueForPatternName("passivation-max-idle-time").equals("null")) {
         return Integer.valueOf(childNode.getTextValueForPatternName("passivation-max-idle-time"));
      }
      return null;
   }

   /**
    * Removes the <code>passivation-max-idle-time</code> element 
    * @return the current instance of <code>PassivationConfigType<T></code> 
    */
   public PassivationConfigType<T> removePassivationMaxIdleTime()
   {
      childNode.removeChildren("passivation-max-idle-time");
      return this;
   }
}
