package org.jboss.shrinkwrap.descriptor.impl.jbossweb60; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.ReplicationConfigType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.ReplicationTriggerType;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.ReplicationGranularityType;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.ReplicationModeType;
import org.jboss.shrinkwrap.descriptor.api.javaee6.GenericBooleanType;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.SnapshotModeType;

/**
 * This class implements the <code> replication-configType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class ReplicationConfigTypeImpl<T> implements Child<T>, ReplicationConfigType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public ReplicationConfigTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public ReplicationConfigTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ReplicationConfigType ElementName: javaee:string ElementType : cache-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>cache-name</code> element
    * @param cacheName the value for the element <code>cache-name</code> 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> cacheName(String cacheName)
   {
      childNode.getOrCreate("cache-name").text(cacheName);
      return this;
   }

   /**
    * Returns the <code>cache-name</code> element
    * @return the node defined for the element <code>cache-name</code> 
    */
   public String getCacheName()
   {
      return childNode.getTextValueForPatternName("cache-name");
   }

   /**
    * Removes the <code>cache-name</code> element 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> removeCacheName()
   {
      childNode.removeChildren("cache-name");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ReplicationConfigType ElementName: jboss:replication-triggerType ElementType : replication-trigger
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: true isDataType: false
   // --------------------------------------------------------------------------------------------------------||
   /**
    * Sets the <code>replication-trigger</code> element
    * @param replicationTrigger the value for the element <code>replication-trigger</code> 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> replicationTrigger(ReplicationTriggerType replicationTrigger)
   {
      childNode.getOrCreate("replication-trigger").text(replicationTrigger);
      return this;
   }
   /**
    * Sets the <code>replication-trigger</code> element
    * @param replicationTrigger the value for the element <code>replication-trigger</code> 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> replicationTrigger(String replicationTrigger)
   {
      childNode.getOrCreate("replication-trigger").text(replicationTrigger);
      return this;
   }

   /**
    * Returns the <code>replication-trigger</code> element
    * @return the value found for the element <code>replication-trigger</code> 
    */
   public ReplicationTriggerType getReplicationTrigger()
   {
      return ReplicationTriggerType.getFromStringValue(childNode.getTextValueForPatternName("replication-trigger"));
   }

   /**
    * Returns the <code>replication-trigger</code> element
    * @return the value found for the element <code>replication-trigger</code> 
    */
   public String  getReplicationTriggerAsString()
   {
      return childNode.getTextValueForPatternName("replication-trigger");
   }

   /**
    * Removes the <code>replication-trigger</code> attribute 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> removeReplicationTrigger()
   {
      childNode.removeAttribute("replication-trigger");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ReplicationConfigType ElementName: jboss:replication-granularityType ElementType : replication-granularity
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: true isDataType: false
   // --------------------------------------------------------------------------------------------------------||
   /**
    * Sets the <code>replication-granularity</code> element
    * @param replicationGranularity the value for the element <code>replication-granularity</code> 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> replicationGranularity(ReplicationGranularityType replicationGranularity)
   {
      childNode.getOrCreate("replication-granularity").text(replicationGranularity);
      return this;
   }
   /**
    * Sets the <code>replication-granularity</code> element
    * @param replicationGranularity the value for the element <code>replication-granularity</code> 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> replicationGranularity(String replicationGranularity)
   {
      childNode.getOrCreate("replication-granularity").text(replicationGranularity);
      return this;
   }

   /**
    * Returns the <code>replication-granularity</code> element
    * @return the value found for the element <code>replication-granularity</code> 
    */
   public ReplicationGranularityType getReplicationGranularity()
   {
      return ReplicationGranularityType.getFromStringValue(childNode.getTextValueForPatternName("replication-granularity"));
   }

   /**
    * Returns the <code>replication-granularity</code> element
    * @return the value found for the element <code>replication-granularity</code> 
    */
   public String  getReplicationGranularityAsString()
   {
      return childNode.getTextValueForPatternName("replication-granularity");
   }

   /**
    * Removes the <code>replication-granularity</code> attribute 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> removeReplicationGranularity()
   {
      childNode.removeAttribute("replication-granularity");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ReplicationConfigType ElementName: jboss:replication-modeType ElementType : replication-mode
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: true isDataType: false
   // --------------------------------------------------------------------------------------------------------||
   /**
    * Sets the <code>replication-mode</code> element
    * @param replicationMode the value for the element <code>replication-mode</code> 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> replicationMode(ReplicationModeType replicationMode)
   {
      childNode.getOrCreate("replication-mode").text(replicationMode);
      return this;
   }
   /**
    * Sets the <code>replication-mode</code> element
    * @param replicationMode the value for the element <code>replication-mode</code> 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> replicationMode(String replicationMode)
   {
      childNode.getOrCreate("replication-mode").text(replicationMode);
      return this;
   }

   /**
    * Returns the <code>replication-mode</code> element
    * @return the value found for the element <code>replication-mode</code> 
    */
   public ReplicationModeType getReplicationMode()
   {
      return ReplicationModeType.getFromStringValue(childNode.getTextValueForPatternName("replication-mode"));
   }

   /**
    * Returns the <code>replication-mode</code> element
    * @return the value found for the element <code>replication-mode</code> 
    */
   public String  getReplicationModeAsString()
   {
      return childNode.getTextValueForPatternName("replication-mode");
   }

   /**
    * Removes the <code>replication-mode</code> attribute 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> removeReplicationMode()
   {
      childNode.removeAttribute("replication-mode");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ReplicationConfigType ElementName: xsd:integer ElementType : backups
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>backups</code> element
    * @param backups the value for the element <code>backups</code> 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> backups(Integer backups)
   {
      childNode.getOrCreate("backups").text(backups);
      return this;
   }

   /**
    * Returns the <code>backups</code> element
    * @return the node defined for the element <code>backups</code> 
    */
   public Integer getBackups()
   {
      if (childNode.getTextValueForPatternName("backups") != null && !childNode.getTextValueForPatternName("backups").equals("null")) {
         return Integer.valueOf(childNode.getTextValueForPatternName("backups"));
      }
      return null;
   }

   /**
    * Removes the <code>backups</code> element 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> removeBackups()
   {
      childNode.removeChildren("backups");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ReplicationConfigType ElementName: javaee:generic-booleanType ElementType : use-jk
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: true isDataType: false
   // --------------------------------------------------------------------------------------------------------||
   /**
    * Sets the <code>use-jk</code> element
    * @param useJk the value for the element <code>use-jk</code> 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> useJk(GenericBooleanType useJk)
   {
      childNode.getOrCreate("use-jk").text(useJk);
      return this;
   }
   /**
    * Sets the <code>use-jk</code> element
    * @param useJk the value for the element <code>use-jk</code> 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> useJk(String useJk)
   {
      childNode.getOrCreate("use-jk").text(useJk);
      return this;
   }

   /**
    * Returns the <code>use-jk</code> element
    * @return the value found for the element <code>use-jk</code> 
    */
   public GenericBooleanType getUseJk()
   {
      return GenericBooleanType.getFromStringValue(childNode.getTextValueForPatternName("use-jk"));
   }

   /**
    * Returns the <code>use-jk</code> element
    * @return the value found for the element <code>use-jk</code> 
    */
   public String  getUseJkAsString()
   {
      return childNode.getTextValueForPatternName("use-jk");
   }

   /**
    * Removes the <code>use-jk</code> attribute 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> removeUseJk()
   {
      childNode.removeAttribute("use-jk");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ReplicationConfigType ElementName: xsd:integer ElementType : max-unreplicated-interval
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>max-unreplicated-interval</code> element
    * @param maxUnreplicatedInterval the value for the element <code>max-unreplicated-interval</code> 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> maxUnreplicatedInterval(Integer maxUnreplicatedInterval)
   {
      childNode.getOrCreate("max-unreplicated-interval").text(maxUnreplicatedInterval);
      return this;
   }

   /**
    * Returns the <code>max-unreplicated-interval</code> element
    * @return the node defined for the element <code>max-unreplicated-interval</code> 
    */
   public Integer getMaxUnreplicatedInterval()
   {
      if (childNode.getTextValueForPatternName("max-unreplicated-interval") != null && !childNode.getTextValueForPatternName("max-unreplicated-interval").equals("null")) {
         return Integer.valueOf(childNode.getTextValueForPatternName("max-unreplicated-interval"));
      }
      return null;
   }

   /**
    * Removes the <code>max-unreplicated-interval</code> element 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> removeMaxUnreplicatedInterval()
   {
      childNode.removeChildren("max-unreplicated-interval");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ReplicationConfigType ElementName: jboss:snapshot-modeType ElementType : snapshot-mode
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: true isDataType: false
   // --------------------------------------------------------------------------------------------------------||
   /**
    * Sets the <code>snapshot-mode</code> element
    * @param snapshotMode the value for the element <code>snapshot-mode</code> 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> snapshotMode(SnapshotModeType snapshotMode)
   {
      childNode.getOrCreate("snapshot-mode").text(snapshotMode);
      return this;
   }
   /**
    * Sets the <code>snapshot-mode</code> element
    * @param snapshotMode the value for the element <code>snapshot-mode</code> 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> snapshotMode(String snapshotMode)
   {
      childNode.getOrCreate("snapshot-mode").text(snapshotMode);
      return this;
   }

   /**
    * Returns the <code>snapshot-mode</code> element
    * @return the value found for the element <code>snapshot-mode</code> 
    */
   public SnapshotModeType getSnapshotMode()
   {
      return SnapshotModeType.getFromStringValue(childNode.getTextValueForPatternName("snapshot-mode"));
   }

   /**
    * Returns the <code>snapshot-mode</code> element
    * @return the value found for the element <code>snapshot-mode</code> 
    */
   public String  getSnapshotModeAsString()
   {
      return childNode.getTextValueForPatternName("snapshot-mode");
   }

   /**
    * Removes the <code>snapshot-mode</code> attribute 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> removeSnapshotMode()
   {
      childNode.removeAttribute("snapshot-mode");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ReplicationConfigType ElementName: xsd:integer ElementType : snapshot-interval
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>snapshot-interval</code> element
    * @param snapshotInterval the value for the element <code>snapshot-interval</code> 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> snapshotInterval(Integer snapshotInterval)
   {
      childNode.getOrCreate("snapshot-interval").text(snapshotInterval);
      return this;
   }

   /**
    * Returns the <code>snapshot-interval</code> element
    * @return the node defined for the element <code>snapshot-interval</code> 
    */
   public Integer getSnapshotInterval()
   {
      if (childNode.getTextValueForPatternName("snapshot-interval") != null && !childNode.getTextValueForPatternName("snapshot-interval").equals("null")) {
         return Integer.valueOf(childNode.getTextValueForPatternName("snapshot-interval"));
      }
      return null;
   }

   /**
    * Removes the <code>snapshot-interval</code> element 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> removeSnapshotInterval()
   {
      childNode.removeChildren("snapshot-interval");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ReplicationConfigType ElementName: javaee:fully-qualified-classType ElementType : session-notification-policy
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>session-notification-policy</code> element
    * @param sessionNotificationPolicy the value for the element <code>session-notification-policy</code> 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> sessionNotificationPolicy(String sessionNotificationPolicy)
   {
      childNode.getOrCreate("session-notification-policy").text(sessionNotificationPolicy);
      return this;
   }

   /**
    * Returns the <code>session-notification-policy</code> element
    * @return the node defined for the element <code>session-notification-policy</code> 
    */
   public String getSessionNotificationPolicy()
   {
      return childNode.getTextValueForPatternName("session-notification-policy");
   }

   /**
    * Removes the <code>session-notification-policy</code> element 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> removeSessionNotificationPolicy()
   {
      childNode.removeChildren("session-notification-policy");
      return this;
   }
}
