package org.jboss.shrinkwrap.descriptor.impl.jbossweb60; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.ServletType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.ServletSecurityType;
import org.jboss.shrinkwrap.descriptor.impl.jbossweb60.ServletSecurityTypeImpl;

/**
 * This class implements the <code> servletType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class ServletTypeImpl<T> implements Child<T>, ServletType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public ServletTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public ServletTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServletType ElementName: xsd:token ElementType : servlet-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>servlet-name</code> element
    * @param servletName the value for the element <code>servlet-name</code> 
    * @return the current instance of <code>ServletType<T></code> 
    */
   public ServletType<T> servletName(String servletName)
   {
      childNode.getOrCreate("servlet-name").text(servletName);
      return this;
   }

   /**
    * Returns the <code>servlet-name</code> element
    * @return the node defined for the element <code>servlet-name</code> 
    */
   public String getServletName()
   {
      return childNode.getTextValueForPatternName("servlet-name");
   }

   /**
    * Removes the <code>servlet-name</code> element 
    * @return the current instance of <code>ServletType<T></code> 
    */
   public ServletType<T> removeServletName()
   {
      childNode.removeChildren("servlet-name");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServletType ElementName: xsd:token ElementType : run-as-principal
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>run-as-principal</code> element
    * @param runAsPrincipal the value for the element <code>run-as-principal</code> 
    * @return the current instance of <code>ServletType<T></code> 
    */
   public ServletType<T> runAsPrincipal(String runAsPrincipal)
   {
      childNode.getOrCreate("run-as-principal").text(runAsPrincipal);
      return this;
   }

   /**
    * Returns the <code>run-as-principal</code> element
    * @return the node defined for the element <code>run-as-principal</code> 
    */
   public String getRunAsPrincipal()
   {
      return childNode.getTextValueForPatternName("run-as-principal");
   }

   /**
    * Removes the <code>run-as-principal</code> element 
    * @return the current instance of <code>ServletType<T></code> 
    */
   public ServletType<T> removeRunAsPrincipal()
   {
      childNode.removeChildren("run-as-principal");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServletType ElementName: jboss:servlet-securityType ElementType : servlet-security
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>servlet-security</code> element with the given value will be created.
    * Otherwise, the existing <code>servlet-security</code> element will be returned.
    * @return  a new or existing instance of <code>ServletSecurityType<ServletType<T>></code> 
    */
   public ServletSecurityType<ServletType<T>> getOrCreateServletSecurity()
   {
      Node node = childNode.getOrCreate("servlet-security");
      ServletSecurityType<ServletType<T>> servletSecurity = new ServletSecurityTypeImpl<ServletType<T>>(this, "servlet-security", childNode, node);
      return servletSecurity;
   }

   /**
    * Removes the <code>servlet-security</code> element 
    * @return the current instance of <code>ServletType<T></code> 
    */
   public ServletType<T> removeServletSecurity()
   {
      childNode.removeChildren("servlet-security");
      return this;
   }
}
