package org.jboss.shrinkwrap.descriptor.impl.wildflyfeaturepack11; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.CopyArtifactsType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.CopyArtifactType;
import org.jboss.shrinkwrap.descriptor.impl.wildflyfeaturepack11.CopyArtifactTypeImpl;

/**
 * This class implements the <code> copy-artifacts-type </code> xsd type 
 * @author <a href="mailto:bmcwhirt@redhat.com">Bob McWhirter</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class CopyArtifactsTypeImpl<T> implements Child<T>, CopyArtifactsType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public CopyArtifactsTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public CopyArtifactsTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: CopyArtifactsType ElementName: wildfly:copy-artifact-type ElementType : copy-artifact
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>copy-artifact</code> element will be created and returned.
    * Otherwise, the first existing <code>copy-artifact</code> element will be returned.
    * @return the instance defined for the element <code>copy-artifact</code> 
    */
   public CopyArtifactType<CopyArtifactsType<T>> getOrCreateCopyArtifact()
   {
      List<Node> nodeList = childNode.get("copy-artifact");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new CopyArtifactTypeImpl<CopyArtifactsType<T>>(this, "copy-artifact", childNode, nodeList.get(0));
      }
      return createCopyArtifact();
   }

   /**
    * Creates a new <code>copy-artifact</code> element 
    * @return the new created instance of <code>CopyArtifactType<CopyArtifactsType<T>></code> 
    */
   public CopyArtifactType<CopyArtifactsType<T>> createCopyArtifact()
   {
      return new CopyArtifactTypeImpl<CopyArtifactsType<T>>(this, "copy-artifact", childNode);
   }

   /**
    * Returns all <code>copy-artifact</code> elements
    * @return list of <code>copy-artifact</code> 
    */
   public List<CopyArtifactType<CopyArtifactsType<T>>> getAllCopyArtifact()
   {
      List<CopyArtifactType<CopyArtifactsType<T>>> list = new ArrayList<CopyArtifactType<CopyArtifactsType<T>>>();
      List<Node> nodeList = childNode.get("copy-artifact");
      for(Node node: nodeList)
      {
         CopyArtifactType<CopyArtifactsType<T>>  type = new CopyArtifactTypeImpl<CopyArtifactsType<T>>(this, "copy-artifact", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>copy-artifact</code> elements 
    * @return the current instance of <code>CopyArtifactType<CopyArtifactsType<T>></code> 
    */
   public CopyArtifactsType<T> removeAllCopyArtifact()
   {
      childNode.removeChildren("copy-artifact");
      return this;
   }
}
