/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.spi;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.jboss.shrinkwrap.descriptor.api.ApiExposition;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.shrinkwrap.descriptor.api.DescriptorImportException;
import org.jboss.shrinkwrap.descriptor.api.DescriptorImporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DescriptorImporterBase<T extends Descriptor>
implements DescriptorImporter<T> {
    protected final Class<T> endUserViewImplType;
    protected final String descriptorName;

    public DescriptorImporterBase(Class<T> endUserViewImplType, String descriptorName) throws IllegalArgumentException {
        if (endUserViewImplType == null) {
            throw new IllegalArgumentException("End user view impl type must be specified");
        }
        if (descriptorName == null || descriptorName.trim().length() == 0) {
            throw new IllegalArgumentException("Descriptor name must be specified");
        }
        this.endUserViewImplType = endUserViewImplType;
        this.descriptorName = descriptorName;
    }

    public T from(File file) throws IllegalArgumentException, DescriptorImportException {
        if (file == null) {
            throw new IllegalArgumentException("File not specified");
        }
        try {
            return this.from(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Specified file does not exist or is a directory: " + file.getAbsolutePath());
        }
    }

    public T from(String string) throws IllegalArgumentException, DescriptorImportException {
        if (string == null) {
            throw new IllegalArgumentException("Input must be specified");
        }
        if (string.trim().length() == 0) {
            return (T)((Descriptor)this.endUserViewImplType.cast(ApiExposition.createFromImplModelType(this.endUserViewImplType, this.descriptorName)));
        }
        return this.from(new ByteArrayInputStream(string.getBytes()));
    }

    public T from(InputStream in) throws IllegalArgumentException, DescriptorImportException {
        return (T)this.from(in, true);
    }
}

