/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.archive.plugins;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.jboss.shrinkwrap.resolver.api.maven.pom.ParsedPomFile;
import org.jboss.shrinkwrap.resolver.impl.maven.archive.plugins.ConfigurationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerPluginConfiguration {
    private static final String COMPILER_PLUGIN_GA = "org.apache.maven.plugins:maven-compiler-plugin";
    private final boolean verbose;
    private final String sourceVersion;
    private final String targetVersion;
    private final Map<String, String> additionalCompilerArguments;

    public CompilerPluginConfiguration(ParsedPomFile pomFile) {
        Map rawValues = pomFile.getPluginConfiguration(COMPILER_PLUGIN_GA);
        Properties properties = pomFile.getProperties();
        this.verbose = ConfigurationUtils.valueAsBoolean(rawValues, new ConfigurationUtils.Key("verbose"), false);
        this.sourceVersion = ConfigurationUtils.valueAsString(rawValues, new ConfigurationUtils.Key("source"), properties.getProperty("maven.compiler.source", "1.5"));
        this.targetVersion = ConfigurationUtils.valueAsString(rawValues, new ConfigurationUtils.Key("target"), properties.getProperty("maven.compiler.target", "1.5"));
        this.additionalCompilerArguments = CompilerPluginConfiguration.prependKeysWithDash(ConfigurationUtils.valueAsMapOfStrings(rawValues, new ConfigurationUtils.Key("compilerArguments"), Collections.<String, String>emptyMap()));
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public String getSourceVersion() {
        return this.sourceVersion;
    }

    public String getTargetVersion() {
        return this.targetVersion;
    }

    public Map<String, String> getAdditionalCompilerArgs() {
        return this.additionalCompilerArguments;
    }

    public CompilerConfiguration asCompilerConfiguration() {
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.setVerbose(this.isVerbose());
        configuration.setSourceVersion(this.getSourceVersion());
        configuration.setTargetVersion(this.getTargetVersion());
        configuration.setCustomCompilerArgumentsAsMap(this.getAdditionalCompilerArgs());
        configuration.setWorkingDirectory(new File("."));
        return configuration;
    }

    private static Map<String, String> prependKeysWithDash(Map<String, String> original) {
        HashMap<String, String> map = new HashMap<String, String>(original.size());
        for (Map.Entry<String, String> entry : original.entrySet()) {
            map.put("-" + entry.getKey(), entry.getValue());
        }
        return map;
    }
}

