/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import eu.maveniverse.maven.mima.context.Context;
import eu.maveniverse.maven.mima.context.ContextOverrides;
import eu.maveniverse.maven.mima.context.Runtime;
import eu.maveniverse.maven.mima.context.Runtimes;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.resolution.ModelResolver;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.util.graph.selector.AndDependencySelector;
import org.eclipse.aether.util.graph.selector.ExclusionDependencySelector;
import org.eclipse.aether.util.graph.selector.OptionalDependencySelector;
import org.eclipse.aether.util.graph.selector.ScopeDependencySelector;
import org.jboss.shrinkwrap.resolver.api.InvalidConfigurationFileException;
import org.jboss.shrinkwrap.resolver.api.NoResolvedResultException;
import org.jboss.shrinkwrap.resolver.api.ResolutionException;
import org.jboss.shrinkwrap.resolver.api.VersionResolutionException;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolvedArtifact;
import org.jboss.shrinkwrap.resolver.api.maven.MavenVersionRangeResult;
import org.jboss.shrinkwrap.resolver.api.maven.MavenWorkingSession;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.pom.ParsedPomFile;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenRemoteRepository;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.MavenResolutionStrategy;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.TransitiveExclusionPolicy;
import org.jboss.shrinkwrap.resolver.impl.maven.ConfigurableMavenWorkingSessionImpl;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenResolvedArtifactImpl;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenVersionRangeResultImpl;
import org.jboss.shrinkwrap.resolver.impl.maven.PostResolutionFilter;
import org.jboss.shrinkwrap.resolver.impl.maven.SecurityActions;
import org.jboss.shrinkwrap.resolver.impl.maven.convert.MavenConverter;
import org.jboss.shrinkwrap.resolver.impl.maven.internal.MavenModelResolver;
import org.jboss.shrinkwrap.resolver.impl.maven.internal.SettingsXmlProfileSelector;
import org.jboss.shrinkwrap.resolver.impl.maven.pom.ParsedPomFileImpl;

public class MavenWorkingSessionImpl
extends ConfigurableMavenWorkingSessionImpl {
    private static final Logger log = Logger.getLogger(MavenWorkingSessionImpl.class.getName());
    private final Set<MavenDependency> dependencyManagement;
    private final List<MavenDependency> dependencies;
    private final Set<MavenDependency> declaredDependencies;
    private Model model;
    private final List<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>();
    private final List<RemoteRepository> additionalRemoteRepositories = new ArrayList<RemoteRepository>();
    private boolean useMavenCentralRepository = true;

    public MavenWorkingSessionImpl() {
        this.dependencies = new ArrayList<MavenDependency>();
        this.dependencyManagement = new LinkedHashSet<MavenDependency>();
        this.declaredDependencies = new LinkedHashSet<MavenDependency>();
    }

    public Set<MavenDependency> getDependencyManagement() {
        return this.dependencyManagement;
    }

    public List<MavenDependency> getDependenciesForResolution() {
        return this.dependencies;
    }

    public Set<MavenDependency> getDeclaredDependencies() {
        return this.declaredDependencies;
    }

    public MavenWorkingSession loadPomFromFile(File pomFile, String ... profiles) throws InvalidConfigurationFileException {
        this.loadPomFromFile(pomFile, (Properties)null, profiles);
        return this;
    }

    public MavenWorkingSession loadPomFromFile(File pomFile, Properties userProperties, String ... profiles) throws InvalidConfigurationFileException {
        Model model;
        ModelBuildingResult result;
        DefaultModelBuildingRequest request = new DefaultModelBuildingRequest().setSystemProperties(SecurityActions.getProperties()).setProfiles(this.getSettingsDefinedProfiles()).setPomFile(pomFile).setActiveProfileIds(SettingsXmlProfileSelector.explicitlyActivatedProfiles(profiles)).setInactiveProfileIds(SettingsXmlProfileSelector.explicitlyDisabledProfiles(profiles));
        if (userProperties != null) {
            request.setUserProperties(userProperties);
        }
        DefaultModelBuilder builder = new DefaultModelBuilderFactory().newInstance();
        try {
            request.setModelResolver((ModelResolver)new MavenModelResolver(this.getSystem(), (RepositorySystemSession)this.getSession(), this.getRemoteRepositories()));
            result = builder.build((ModelBuildingRequest)request);
        }
        catch (ModelBuildingException e) {
            String pomPath = request.getPomFile().getAbsolutePath();
            StringBuilder sb = new StringBuilder("Found ").append(e.getProblems().size()).append(" problems while building POM model from ").append(pomPath).append("\n");
            int counter = 1;
            for (ModelProblem problem : e.getProblems()) {
                sb.append(counter++).append("/ ").append(problem).append("\n");
            }
            throw new InvalidConfigurationFileException(sb.toString());
        }
        this.model = model = result.getEffectiveModel();
        for (Repository repository : model.getRepositories()) {
            this.remoteRepositories.add(MavenConverter.asRemoteRepository(repository));
        }
        return this;
    }

    private Collection<ArtifactResult> resolveProjectLocal(List<MavenDependency> depsForResolution, Set<MavenDependency> additionalDependencies) {
        ArrayList<ArtifactResult> projectLocalDependencies = new ArrayList<ArtifactResult>(depsForResolution.size());
        for (MavenDependency dependency : depsForResolution) {
            Path resolved = this.resolveProjectLocal(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), Optional.ofNullable(dependency.getClassifier()), Optional.ofNullable(dependency.getPackaging().getExtension()), additionalDependencies);
            if (resolved == null || !resolved.toFile().exists()) continue;
            DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), dependency.getPackaging().getExtension(), dependency.getVersion(), null, resolved.toFile());
            ArtifactResult result = new ArtifactResult(new ArtifactRequest().setDependencyNode((DependencyNode)new DefaultDependencyNode(new Dependency((Artifact)artifact, dependency.getScope().name(), Boolean.valueOf(dependency.isOptional())))));
            result.setArtifact((Artifact)artifact);
            projectLocalDependencies.add(result);
        }
        return projectLocalDependencies;
    }

    private Path resolveProjectLocal(String groupId, String artifactId, String version, Optional<String> classifier, Optional<String> extension, Set<MavenDependency> additionalDependencies) {
        Path projectLocalRepository = this.findProjectLocalRepository();
        if (projectLocalRepository == null) {
            return null;
        }
        Predicate<String> isNotEmpty = s -> !s.isEmpty();
        this.processAdditionalDependencies(projectLocalRepository, groupId, artifactId, version, additionalDependencies);
        return projectLocalRepository.resolve(groupId).resolve(artifactId).resolve(version).resolve(MavenWorkingSessionImpl.toVersionedArtifact(artifactId, version) + classifier.filter(isNotEmpty).map(c -> "-" + c).orElse("") + "." + extension.filter(isNotEmpty).orElse("jar"));
    }

    private static String toVersionedArtifact(String artifactId, String version) {
        return artifactId + "-" + version;
    }

    private void processAdditionalDependencies(Path projectLocalRepository, String groupId, String artifactId, String version, Set<MavenDependency> additionalDependencies) {
        Path directory = projectLocalRepository.resolve(groupId).resolve(artifactId).resolve(version);
        File consumerPom = directory.resolve(MavenWorkingSessionImpl.toVersionedArtifact(artifactId, version) + "-consumer.pom").toFile();
        if (consumerPom.exists()) {
            Set transitiveDependencies = this.loadPomFromFile(consumerPom, new String[0]).getParsedPomFile().getDependencies();
            transitiveDependencies.removeAll(additionalDependencies);
            if (!transitiveDependencies.isEmpty()) {
                additionalDependencies.addAll(transitiveDependencies);
                transitiveDependencies.forEach(dependency -> this.processAdditionalDependencies(projectLocalRepository, dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), additionalDependencies));
            }
        }
    }

    private List<MavenDependency> filterFromLocal(List<MavenDependency> depsForResolution, Collection<ArtifactResult> projectLocalDependencies) {
        return depsForResolution.stream().filter(dependency -> projectLocalDependencies.stream().noneMatch(result -> MavenConverter.asArtifact((MavenCoordinate)dependency, this.getSession().getArtifactTypeRegistry()).setProperties(Collections.EMPTY_MAP).equals(result.getArtifact().setFile(null)))).collect(Collectors.toList());
    }

    private Path findProjectLocalRepository() {
        Path targetPath = Paths.get("target/project-local-repo", new String[0]);
        for (Path currentPath = Paths.get("", new String[0]).toAbsolutePath(); currentPath != null; currentPath = currentPath.getParent()) {
            Path path = currentPath.resolve(targetPath);
            if (!path.toFile().exists()) continue;
            return path;
        }
        return null;
    }

    public Collection<MavenResolvedArtifact> resolveDependencies(MavenResolutionStrategy strategy) throws ResolutionException {
        List<MavenDependency> resolveFromRepository;
        List<MavenDependency> depsForResolution = Collections.unmodifiableList(new ArrayList<MavenDependency>(this.getDependenciesForResolution()));
        ArrayList<MavenDependency> depManagement = new ArrayList<MavenDependency>(this.getDependencyManagement());
        List<RemoteRepository> repos = this.getRemoteRepositories();
        List<ArtifactResult> projectLocalDependencies = Collections.emptyList();
        if (Boolean.getBoolean("org.jboss.shrinkwrap.resolver.maven.disableProjectLocal")) {
            resolveFromRepository = depsForResolution;
        } else {
            LinkedHashSet<MavenDependency> allDependencies = new LinkedHashSet<MavenDependency>(depsForResolution);
            projectLocalDependencies = this.resolveProjectLocal(depsForResolution, allDependencies);
            resolveFromRepository = this.filterFromLocal(allDependencies.stream().collect(Collectors.toList()), projectLocalDependencies);
        }
        CollectRequest request = new CollectRequest(MavenConverter.asDependencies(resolveFromRepository, this.getSession().getArtifactTypeRegistry()), MavenConverter.asDependencies(depManagement, this.getSession().getArtifactTypeRegistry()), repos);
        Collection<Object> results = Collections.emptyList();
        LinkedHashSet<Object> dependencySelectors = new LinkedHashSet<Object>(3);
        TransitiveExclusionPolicy transitiveExclusionPolicy = strategy.getTransitiveExclusionPolicy();
        ScopeType[] filteredScopes = transitiveExclusionPolicy.getFilteredScopes();
        int numFilteredScopes = filteredScopes.length;
        String[] filteredScopeStrings = new String[numFilteredScopes];
        for (int i = 0; i < numFilteredScopes; ++i) {
            filteredScopeStrings[i] = filteredScopes[i].toString();
        }
        if (numFilteredScopes > 0) {
            dependencySelectors.add(new ScopeDependencySelector(filteredScopeStrings));
        }
        if (!transitiveExclusionPolicy.allowOptional()) {
            dependencySelectors.add(new OptionalDependencySelector());
        }
        dependencySelectors.add(new ExclusionDependencySelector());
        AndDependencySelector dependencySelector = new AndDependencySelector(dependencySelectors);
        this.getSession().setDependencySelector((DependencySelector)dependencySelector);
        try {
            results = this.getSystem().resolveDependencies((RepositorySystemSession)this.getSession(), this, request, strategy.getResolutionFilters());
        }
        catch (DependencyResolutionException e) {
            throw MavenWorkingSessionImpl.wrapException(e);
        }
        ArrayList<MavenResolvedArtifact> resolvedArtifacts = new ArrayList<MavenResolvedArtifact>(results.size() + projectLocalDependencies.size());
        for (ArtifactResult artifactResult : projectLocalDependencies) {
            resolvedArtifacts.add(MavenResolvedArtifactImpl.fromArtifactResult(artifactResult));
        }
        for (ArtifactResult artifactResult : results) {
            resolvedArtifacts.add(MavenResolvedArtifactImpl.fromArtifactResult(artifactResult));
        }
        this.getDependenciesForResolution().clear();
        return PostResolutionFilter.filter(resolvedArtifacts, depsForResolution, strategy);
    }

    public MavenVersionRangeResult resolveVersionRange(MavenCoordinate coordinate) throws VersionResolutionException {
        Artifact artifact = MavenConverter.asArtifact(coordinate, this.getSession().getArtifactTypeRegistry());
        VersionRangeRequest versionRangeRequest = new VersionRangeRequest(artifact, this.getRemoteRepositories(), null);
        try {
            VersionRangeResult versionRangeResult = this.getSystem().resolveVersionRange((RepositorySystemSession)this.getSession(), versionRangeRequest);
            if (!versionRangeResult.getVersions().isEmpty()) {
                return new MavenVersionRangeResultImpl(artifact, versionRangeResult);
            }
            List exceptions = versionRangeResult.getExceptions();
            if (exceptions.isEmpty()) {
                return new MavenVersionRangeResultImpl(artifact, versionRangeResult);
            }
            StringBuilder builder = new StringBuilder("Version range request failed with ").append(exceptions.size()).append(" exceptions.").append("\n");
            int counter = 1;
            for (Exception exception : exceptions) {
                log.log(Level.SEVERE, "Version range request failed", exception);
                builder.append(counter++).append("/ ").append(exception.getLocalizedMessage()).append("\n");
            }
            throw new VersionResolutionException(builder.toString());
        }
        catch (VersionRangeResolutionException vrre) {
            throw new VersionResolutionException("Version range request failed", (Throwable)vrre);
        }
    }

    public ParsedPomFile getParsedPomFile() {
        return new ParsedPomFileImpl(this.model, this.getSession().getArtifactTypeRegistry());
    }

    public void disableMavenCentral() {
        log.log(Level.FINEST, "Disabling Maven Central");
        this.useMavenCentralRepository = false;
    }

    public void addRemoteRepo(MavenRemoteRepository repository) {
        RemoteRepository.Builder builder = new RemoteRepository.Builder(repository.getId(), repository.getType(), repository.getUrl());
        builder.setPolicy(new RepositoryPolicy(true, repository.getUpdatePolicy() == null ? null : repository.getUpdatePolicy().apiValue(), repository.getChecksumPolicy() == null ? null : repository.getChecksumPolicy().apiValue()));
        this.additionalRemoteRepositories.removeIf(r -> r.getId().equals(repository.getId()));
        this.additionalRemoteRepositories.add(builder.build());
    }

    private List<RemoteRepository> getRemoteRepositories() throws IllegalStateException {
        if (this.isOffline()) {
            log.log(Level.FINE, "No remote repositories will be available, working in offline mode");
            return Collections.emptyList();
        }
        ContextOverrides.Builder contextOverridesBuilder = ContextOverrides.create();
        contextOverridesBuilder.withUserSettings(true);
        contextOverridesBuilder.withEffectiveSettings((Object)this.getSettings());
        contextOverridesBuilder.addRepositoriesOp(ContextOverrides.AddRepositoriesOp.APPEND);
        ArrayList<RemoteRepository> ctxrepo = new ArrayList<RemoteRepository>();
        if (this.useMavenCentralRepository && this.remoteRepositories.stream().noneMatch(r -> ContextOverrides.CENTRAL.getId().equals(r.getId())) && this.additionalRemoteRepositories.stream().noneMatch(r -> ContextOverrides.CENTRAL.getId().equals(r.getId()))) {
            ctxrepo.add(ContextOverrides.CENTRAL);
        }
        this.remoteRepositories.forEach(r -> this.addReplace((List<RemoteRepository>)ctxrepo, (RemoteRepository)r));
        this.additionalRemoteRepositories.forEach(r -> this.addReplace((List<RemoteRepository>)ctxrepo, (RemoteRepository)r));
        contextOverridesBuilder.repositories(ctxrepo);
        Runtime runtime = Runtimes.INSTANCE.getRuntime();
        try (Context context = runtime.create(contextOverridesBuilder.build());){
            ArrayList<RemoteRepository> result = new ArrayList<RemoteRepository>(context.remoteRepositories());
            if (!this.useMavenCentralRepository) {
                result.removeIf(r -> ContextOverrides.CENTRAL.getId().equals(r.getId()));
            }
            if (log.isLoggable(Level.FINER)) {
                for (RemoteRepository repository : result) {
                    log.finer("Repository " + repository.getUrl() + " have been made available for artifact resolution");
                }
            }
            ArrayList arrayList = new ArrayList(result);
            return arrayList;
        }
    }

    private void addReplace(List<RemoteRepository> remoteRepositories, RemoteRepository repository) {
        remoteRepositories.removeIf(r -> Objects.equals(repository.getId(), r.getId()));
        remoteRepositories.add(repository);
    }

    private List<Profile> getSettingsDefinedProfiles() {
        return MavenConverter.asProfiles(this.getSettings().getProfiles());
    }

    private static ResolutionException wrapException(DependencyResolutionException e) {
        Throwable cause = e;
        Throwable nextCause = null;
        while ((nextCause = cause.getCause()) != null) {
            cause = nextCause;
        }
        if (cause instanceof ArtifactResolutionException) {
            throw new NoResolvedResultException("Unable to get artifact from the repository due to: " + e.getMessage() + ", caused by: " + cause.getMessage());
        }
        if (cause instanceof DependencyCollectionException) {
            throw new NoResolvedResultException("Unable to collect dependency tree for given dependencies due to: " + e.getMessage() + ", caused by: " + cause.getMessage(), (Throwable)e);
        }
        throw new NoResolvedResultException("Unable to collect/resolve dependency tree for a resolution due to: " + e.getMessage() + ", caused by: " + cause.getMessage(), (Throwable)e);
    }
}

