/*
 * Copyright (c) 2002, 2003, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package org.jboss.com.sun.corba.se.spi.orbutil.fsm;

/**
 * This interface must be implemented by any class that is used as a state in a FSM. The FSM only needs the identity of
 * this object, so all that is really needs is the default equals implementation. The toString() method should also be
 * overridden to give a concise description or name of the state. The StateImpl class handles this.
 * <P>
 * Pre- and post- actions are taken only on completed transitions between different states. Assume that the FSM is in
 * state A, and the FSM will transition to state B under input I with action X. If A != B and X completes successfully,
 * then after X completes execution, A.postAction is executed, followed by B.preAction.
 * 
 * @author Ken Cavanaugh
 */
public interface State
{
    /**
     * Method that defines action that occurs whenever this state is entered. Any exceptions thrown by this method are
     * ignored.
     */
    void preAction(FSM fsm);

    /**
     * Method that defines action that occurs whenever this state is exited. Any exceptions thrown by this method are
     * ignored.
     */
    void postAction(FSM fsm);
}

// end of State.java
