/*
 * Copyright (c) 2002, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package org.jboss.com.sun.corba.se.spi.resolver;

import java.util.Set;

/**
 * Resolver defines the operations needed to support ORB operations for resolve_initial_references and
 * list_initial_services.
 */
public interface Resolver
{
    /**
     * Look up the name using this resolver and return the CORBA object reference bound to this name, if any. Returns
     * null if no object is bound to the name.
     */
    org.omg.CORBA.Object resolve(String name);

    /**
     * Return the entire collection of names that are currently bound by this resolver. Resulting collection contains
     * only strings for which resolve does not return null. Some resolvers may not support this method, in which case
     * they return an empty set.
     */
    Set<Object> list();
}
