/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces.mock;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.test.faces.mock.Environment;
import org.jboss.test.faces.mock.FacesMock;
import org.jboss.test.faces.mock.Mock;
import org.jboss.test.faces.mock.MockController;
import org.jboss.test.faces.mock.MockFacesContext;
import org.jboss.test.faces.mock.MockFacesEnvironment;
import org.jboss.test.faces.mock.Strict;
import org.jboss.test.faces.mock.Stub;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class MockTestRunner
extends BlockJUnit4ClassRunner {
    public MockTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected Set<Field> getFields(Class<?> c) {
        HashSet<Field> fields = new HashSet<Field>(Arrays.asList(c.getDeclaredFields()));
        while ((c = c.getSuperclass()) != null) {
            for (Field f : c.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers())) continue;
                fields.add(f);
            }
        }
        return fields;
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        super.runChild(method, notifier);
    }

    protected Object createTest() throws Exception {
        Class c = this.getTestClass().getJavaClass();
        Set<Field> testFields = this.getFields(c);
        Map<Field, Binding> fieldValues = MockTestRunner.getMockValues(testFields);
        Object test = super.createTest();
        for (Field field : fieldValues.keySet()) {
            Binding binding = fieldValues.get(field);
            field.setAccessible(true);
            if (null == binding.getValue() || field.get(test) != null) continue;
            field.set(test, binding.getValue());
        }
        return test;
    }

    private static Map<Field, Binding> getMockValues(Set<Field> testFields) {
        HashMap<Field, Binding> mocksAndStubs = new HashMap<Field, Binding>();
        FieldModule module = new FieldModule();
        for (Field field : testFields) {
            if (field.isAnnotationPresent(Strict.class)) {
                mocksAndStubs.put(field, MockTestRunner.createMockBinding(field, FacesMock.createStrictMock(MockTestRunner.notEmpty(field.getAnnotation(Strict.class).value()), field.getType())));
            }
            if (field.isAnnotationPresent(Mock.class)) {
                mocksAndStubs.put(field, MockTestRunner.createMockBinding(field, FacesMock.createMock(MockTestRunner.notEmpty(field.getAnnotation(Mock.class).value()), field.getType())));
                continue;
            }
            if (field.isAnnotationPresent(Stub.class)) {
                mocksAndStubs.put(field, MockTestRunner.createMockBinding(field, FacesMock.createNiceMock(MockTestRunner.notEmpty(field.getAnnotation(Stub.class).value()), field.getType())));
                continue;
            }
            if (!field.getType().isAssignableFrom(MockController.class)) continue;
            mocksAndStubs.put(field, MockTestRunner.createBinding(module));
        }
        module.setBindings(mocksAndStubs.values());
        return mocksAndStubs;
    }

    private static Binding createMockBinding(Field field, Object value) {
        Binding bind = MockTestRunner.createMockBinding(value);
        if (field.isAnnotationPresent(Environment.class)) {
            MockFacesEnvironment environment = (MockFacesEnvironment)value;
            block9: for (Environment.Feature feature : field.getAnnotation(Environment.class).value()) {
                switch (feature) {
                    case EXTERNAL_CONTEXT: {
                        environment.withExternalContext();
                        continue block9;
                    }
                    case EL_CONTEXT: {
                        environment.withELContext();
                        continue block9;
                    }
                    case APPLICATION: {
                        environment.withApplication();
                        continue block9;
                    }
                    case FACTORIES: {
                        environment.withFactories();
                        continue block9;
                    }
                    case RENDER_KIT: {
                        environment.withRenderKit();
                        continue block9;
                    }
                    case SERVLET_REQUEST: {
                        environment.withServletRequest();
                        continue block9;
                    }
                    case RESPONSE_WRITER: {
                        environment.withReSponseWriter();
                    }
                }
            }
        }
        return bind;
    }

    private static Binding createMockBinding(Object value) {
        Binding bind = MockTestRunner.createBinding(value);
        bind.setMock(true);
        return bind;
    }

    private static Binding createBinding(Object value) {
        Binding bind = new Binding();
        bind.setValue(value);
        return bind;
    }

    private static String notEmpty(String value) {
        return "".equals(value) ? null : value;
    }

    protected Statement withAfters(FrameworkMethod method, Object target, Statement statement) {
        Statement afterStatement = super.withAfters(method, target, statement);
        Statement resetContextStatement = new Statement(){

            public void evaluate() throws Throwable {
                MockFacesContext.setCurrentInstance(null);
            }
        };
        return new ComposedStatement(afterStatement, resetContextStatement);
    }

    private static class ComposedStatement
    extends Statement {
        private Statement[] statements;

        public ComposedStatement(Statement ... statements) {
            this.statements = statements;
        }

        public void evaluate() throws Throwable {
            for (Statement statement : this.statements) {
                statement.evaluate();
            }
        }
    }

    protected static final class Binding {
        private Object value;
        private boolean mock;

        protected Binding() {
        }

        void setValue(Object value) {
            this.value = value;
        }

        Object getValue() {
            return this.value;
        }

        public void setMock(boolean mock) {
            this.mock = mock;
        }

        public boolean isMock() {
            return this.mock;
        }
    }

    protected static final class FieldModule
    implements MockController {
        Collection<Binding> fields;

        public void setBindings(Collection<Binding> bindings) {
            this.fields = new ArrayList<Binding>(bindings);
        }

        private void perform(Invoker invoker, Object ... objects) {
            for (Binding field : this.fields) {
                if (!field.isMock()) continue;
                if (field.getValue() instanceof MockFacesEnvironment) {
                    invoker.perform((MockFacesEnvironment)field.getValue());
                    continue;
                }
                invoker.perform(field.getValue());
            }
            invoker.perform(objects);
        }

        @Override
        public void reset(Object ... objects) {
            this.perform(new Invoker(){

                @Override
                public void perform(MockFacesEnvironment environment) {
                    environment.reset();
                }

                @Override
                public void perform(Object ... objects) {
                    FacesMock.reset(objects);
                }
            }, objects);
        }

        @Override
        public void resetToNice(Object ... objects) {
            this.perform(new Invoker(){

                @Override
                public void perform(MockFacesEnvironment environment) {
                    environment.resetToNice();
                }

                @Override
                public void perform(Object ... objects) {
                    FacesMock.resetToNice(objects);
                }
            }, objects);
        }

        @Override
        public void resetToStrict(Object ... objects) {
            this.perform(new Invoker(){

                @Override
                public void perform(MockFacesEnvironment environment) {
                    environment.resetToStrict();
                }

                @Override
                public void perform(Object ... objects) {
                    FacesMock.resetToStrict(objects);
                }
            }, objects);
        }

        @Override
        public void resetToDefault(Object ... objects) {
            this.perform(new Invoker(){

                @Override
                public void perform(MockFacesEnvironment environment) {
                    environment.resetToDefault();
                }

                @Override
                public void perform(Object ... objects) {
                    FacesMock.resetToDefault(objects);
                }
            }, objects);
        }

        @Override
        public void verify(Object ... objects) {
            this.perform(new Invoker(){

                @Override
                public void perform(MockFacesEnvironment environment) {
                    environment.verify();
                }

                @Override
                public void perform(Object ... objects) {
                    FacesMock.verify(objects);
                }
            }, objects);
        }

        @Override
        public void replay(Object ... objects) {
            this.perform(new Invoker(){

                @Override
                public void perform(MockFacesEnvironment environment) {
                    environment.replay();
                }

                @Override
                public void perform(Object ... objects) {
                    FacesMock.replay(objects);
                }
            }, objects);
        }

        @Override
        public void release() {
            this.perform(new Invoker(){

                @Override
                public void perform(MockFacesEnvironment environment) {
                    environment.release();
                }

                @Override
                public void perform(Object ... objects) {
                }
            }, new Object[0]);
        }

        @Override
        public <T> T createMock(Class<T> clazz) {
            T mock = FacesMock.createMock(clazz);
            this.fields.add(MockTestRunner.createMockBinding(mock));
            return mock;
        }

        @Override
        public <T> T createMock(String name, Class<T> clazz) {
            T mock = FacesMock.createMock(name, clazz);
            this.fields.add(MockTestRunner.createMockBinding(mock));
            return mock;
        }

        @Override
        public <T> T createNiceMock(Class<T> clazz) {
            T mock = FacesMock.createNiceMock(clazz);
            this.fields.add(MockTestRunner.createMockBinding(mock));
            return mock;
        }

        @Override
        public <T> T createNiceMock(String name, Class<T> clazz) {
            T mock = FacesMock.createNiceMock(name, clazz);
            this.fields.add(MockTestRunner.createMockBinding(mock));
            return mock;
        }

        @Override
        public <T> T createStrictMock(Class<T> clazz) {
            T mock = FacesMock.createStrictMock(clazz);
            this.fields.add(MockTestRunner.createMockBinding(mock));
            return mock;
        }

        @Override
        public <T> T createStrictMock(String name, Class<T> clazz) {
            T mock = FacesMock.createStrictMock(name, clazz);
            this.fields.add(MockTestRunner.createMockBinding(mock));
            return mock;
        }

        static interface Invoker {
            public void perform(Object ... var1);

            public void perform(MockFacesEnvironment var1);
        }
    }
}

