/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces.writer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jboss.test.faces.writer.Criteria;
import org.jboss.test.faces.writer.ElementRecord;
import org.jboss.test.faces.writer.NotFoundException;
import org.jboss.test.faces.writer.Record;

public class ElementCriteria
implements Criteria {
    private final Collection<? extends Record> base;
    private final String name;
    private int level = Integer.MAX_VALUE;
    private String attribute;
    private Pattern attributePattern;
    private int position = Integer.MAX_VALUE;
    private Pattern contentPattern;
    private Pattern namePattern;

    public ElementCriteria(Record base, String name) {
        this(Collections.singleton(base), name);
    }

    public ElementCriteria(Collection<? extends Record> base, String name) {
        this.base = base;
        this.name = name;
        this.namePattern = Pattern.compile(name);
    }

    public ElementCriteria atLevel(int level) {
        this.level = level;
        return this;
    }

    public ElementCriteria atPosition(int position) {
        this.position = position;
        return this;
    }

    public ElementCriteria withAttribute(String name) {
        this.attribute = name;
        this.attributePattern = null;
        return this;
    }

    public ElementCriteria withAttribute(String name, String regex) {
        this.attribute = name;
        this.attributePattern = Pattern.compile(regex);
        return this;
    }

    public ElementCriteria contains(String regex) {
        this.contentPattern = Pattern.compile(regex);
        return this;
    }

    public String getName() throws NotFoundException {
        return this.lookupSingleElement().getName();
    }

    public String getText() throws NotFoundException {
        return this.lookupSingleElement().getText();
    }

    public Object getAttribute(String name) throws NotFoundException {
        ElementRecord elementRecord = this.lookupSingleElement();
        if (elementRecord.containsAttribute(name)) {
            return elementRecord.getAttribute(name).getValue();
        }
        throw new NotFoundException("Element " + elementRecord.getName() + " has no attribute " + name);
    }

    public boolean matches() {
        return this.lookup().size() > 0;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.level != Integer.MAX_VALUE) {
            for (int i = 0; i < this.level; ++i) {
                result.append("/*");
            }
        }
        result.append('/').append(this.name);
        if (this.position != Integer.MAX_VALUE) {
            result.append("(").append(this.position).append(")");
        }
        if (null != this.attribute) {
            result.append("[").append(this.attribute);
            if (null != this.attributePattern) {
                result.append("='").append(this.attributePattern).append("'");
            }
            result.append("]");
        }
        if (null != this.contentPattern) {
            result.append(" '").append(this.attributePattern).append("'");
        }
        return result.toString();
    }

    private ElementRecord lookupSingleElement() throws NotFoundException {
        List<ElementRecord> result = this.lookup();
        if (0 == result.size()) {
            throw new NotFoundException("No element found for criteria " + this.toString());
        }
        if (result.size() > 1) {
            throw new NotFoundException("More then one element found for criteria " + this.toString());
        }
        return result.get(0);
    }

    private List<ElementRecord> lookup() {
        ArrayList<ElementRecord> result = new ArrayList<ElementRecord>();
        for (Record record : this.base) {
            result.addAll(this.lookup(record, 0, 0));
        }
        return result;
    }

    private List<ElementRecord> lookup(Record record, int level, int currentPosition) {
        ArrayList<ElementRecord> result;
        block5: {
            result = new ArrayList<ElementRecord>();
            if (level > this.level) break block5;
            if (record instanceof ElementRecord) {
                ElementRecord element = (ElementRecord)record;
                if (!(!this.namePattern.matcher(element.getName()).matches() || this.level != Integer.MAX_VALUE && level != this.level || this.position != Integer.MAX_VALUE && currentPosition != this.position || null != this.attribute && !element.containsAttribute(this.attribute) || null != this.attributePattern && !this.attributePattern.matcher(element.getAttribute(this.attribute).getValue().toString()).matches() || null != this.contentPattern && !this.contentPattern.matcher(element.getText()).matches())) {
                    result.add(element);
                }
                int childPosition = 0;
                for (Record childRecord : record.getChildren()) {
                    result.addAll(this.lookup(childRecord, level + 1, childPosition));
                    if (!(childRecord instanceof ElementRecord)) continue;
                    ++childPosition;
                }
            } else {
                for (Record childRecord : record.getChildren()) {
                    result.addAll(this.lookup(childRecord, level, currentPosition));
                    if (!(childRecord instanceof ElementRecord)) continue;
                    ++currentPosition;
                }
            }
        }
        return result;
    }

    @Override
    public ElementCriteria element(String name) {
        ArrayList<Record> records = new ArrayList<Record>();
        List<ElementRecord> elements = this.lookup();
        for (ElementRecord elementRecord : elements) {
            records.addAll(elementRecord.getChildren());
        }
        return new ElementCriteria(records, name);
    }
}

