/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces.mockito.component;

import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import org.jboss.test.faces.mockito.component.Facet;
import org.jboss.test.faces.mockito.component.TreeBuilder;
import org.jboss.test.faces.mockito.component.TreeBuilderImpl;
import org.mockito.Mockito;

public class ViewBuilder
extends TreeBuilderImpl<UIViewRoot> {
    protected ViewBuilder(UIViewRoot component) {
        super(component);
    }

    public static ViewBuilder createView() {
        return ViewBuilder.createView((UIViewRoot)Mockito.mock(UIViewRoot.class));
    }

    public static ViewBuilder createView(UIViewRoot mockViewRoot) {
        ViewBuilder treeBuilder = new ViewBuilder(mockViewRoot);
        Mockito.when((Object)mockViewRoot.getParent()).thenReturn(null);
        return treeBuilder;
    }

    public ViewBuilder setViewId(String viewId) {
        Mockito.when((Object)((UIViewRoot)this.getComponent()).getViewId()).thenReturn((Object)viewId);
        return this;
    }

    public ViewBuilder children(TreeBuilder<?> ... builders) {
        super.children(builders);
        return this;
    }

    public ViewBuilder facets(Facet<?> ... facets) {
        super.facets(facets);
        return this;
    }

    public static TreeBuilder<UIComponent> component() {
        return ViewBuilder.component((UIComponent)Mockito.mock(UIComponent.class));
    }

    public static <T extends UIComponent> TreeBuilder<T> component(Class<T> childType) {
        return ViewBuilder.component((UIComponent)Mockito.mock(childType));
    }

    public static <T extends UIComponent> TreeBuilder<T> component(T child) {
        TreeBuilderImpl<T> treeBuilder = ViewBuilder.createComponent(child);
        return treeBuilder;
    }

    private static <T extends UIComponent> TreeBuilderImpl<T> createComponent(T child) {
        TreeBuilderImpl<T> treeBuilder = new TreeBuilderImpl<T>(child);
        return treeBuilder;
    }

    public static Facet<UIComponent> facet(String name) {
        return ViewBuilder.facet(name, (UIComponent)Mockito.mock(UIComponent.class));
    }

    public static <T extends UIComponent> Facet<T> facet(String name, Class<T> childType) {
        return ViewBuilder.facet(name, (UIComponent)Mockito.mock(childType));
    }

    public static <T extends UIComponent> Facet<T> facet(String name, T child) {
        TreeBuilderImpl<T> treeBuilder = ViewBuilder.createComponent(child);
        return new Facet<T>(name, treeBuilder);
    }
}

