/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces.jetty;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.test.faces.TestException;
import org.jboss.test.faces.jetty.BadResource;
import org.jboss.test.faces.jetty.JettyDirectoryMapAdapter;
import org.jboss.test.faces.jetty.VirtualResourceURLStreamHandler;
import org.jboss.test.faces.staging.DirectoryMap;
import org.jboss.test.faces.staging.ServerResourcePath;
import org.mortbay.resource.Resource;

public class VirtualDirectoryResource
extends Resource {
    private static final long serialVersionUID = 695315141388366832L;
    private static final String[] EMPTY_STRINGS_ARRAY = new String[0];
    private String path;
    private DirectoryMap<Resource, VirtualDirectoryResource> directoryMap = new DirectoryMap((Object)this, JettyDirectoryMapAdapter.INSTANCE);

    public VirtualDirectoryResource(String path) {
        this.path = path;
    }

    public boolean delete() throws SecurityException {
        throw new SecurityException(this.path);
    }

    public boolean exists() {
        return true;
    }

    public File getFile() throws IOException {
        return null;
    }

    public InputStream getInputStream() throws IOException {
        throw new FileNotFoundException(this.path);
    }

    public String getName() {
        return this.path;
    }

    public OutputStream getOutputStream() throws IOException, SecurityException {
        throw new FileNotFoundException(this.path);
    }

    public URL getURL() {
        try {
            return new URL("jetty_virtual_resource", null, -1, this.path, VirtualResourceURLStreamHandler.INSTANCE);
        }
        catch (MalformedURLException e) {
            throw new TestException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isDirectory() {
        return true;
    }

    public long lastModified() {
        return -1L;
    }

    public long length() {
        return 0L;
    }

    public String[] list() {
        return this.directoryMap.getResourceNames().toArray(EMPTY_STRINGS_ARRAY);
    }

    public void release() {
        for (Resource childResource : this.directoryMap.getResources()) {
            childResource.release();
        }
    }

    public boolean renameTo(Resource dest) throws SecurityException {
        throw new SecurityException(this.path);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VirtualResource: ");
        sb.append(this.path);
        try {
            File file = this.getFile();
            if (file != null) {
                sb.append(", ");
                sb.append(file.getAbsolutePath());
            } else {
                URL url = this.getURL();
                sb.append(", ");
                sb.append(url.toExternalForm());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public Resource addPath(String path) throws IOException, MalformedURLException {
        Resource resource = (Resource)this.directoryMap.getResource(new ServerResourcePath("/" + path));
        if (resource == null) {
            resource = new BadResource(path);
        }
        return resource;
    }

    public VirtualDirectoryResource createChildDirectory(String name) {
        return (VirtualDirectoryResource)((Object)this.directoryMap.addDirectory(name));
    }

    public void addResource(String string, Resource childResource) {
        this.directoryMap.addResource(new ServerResourcePath(string), (Object)childResource);
    }

    public void createChildDirectory(ServerResourcePath serverResourcePath) {
        this.directoryMap.addDirectory(serverResourcePath);
    }
}

