/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit;

import java.util.ArrayList;
import org.jboss.unit.TestId;
import org.jboss.unit.util.CollectionTools;

public abstract class TestIdFormat {
    public static final TestIdFormat CLASSIC = new TestIdFormat(){

        public TestId parse(String fqn) {
            if (fqn == null) {
                throw new IllegalArgumentException("No null fqn accepted");
            }
            int from = 0;
            ArrayList<String> names = new ArrayList<String>();
            while (true) {
                int pos;
                if ((pos = fqn.indexOf(46, from)) == -1) break;
                names.add(fqn.substring(from, pos));
                from = pos + 1;
            }
            names.add(fqn.substring(from));
            return new TestId(names);
        }

        public String toString(TestId testId) {
            if (testId == null) {
                throw new IllegalArgumentException("No null test id accepted");
            }
            if (testId.getLength() == 0) {
                return "";
            }
            StringBuilder builder = new StringBuilder();
            for (String name : CollectionTools.iterable(testId.iterator())) {
                builder.append(name);
                builder.append('.');
            }
            return builder.substring(0, builder.length() - 1);
        }
    };

    public abstract TestId parse(String var1) throws IllegalArgumentException;

    public abstract String toString(TestId var1) throws IllegalArgumentException;
}

