/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.driver.impl.pojo;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.jboss.unit.Failure;
import org.jboss.unit.TestId;
import org.jboss.unit.driver.AbstractTestDriver;
import org.jboss.unit.driver.DriverCommand;
import org.jboss.unit.driver.DriverResponse;
import org.jboss.unit.driver.command.StartTestCommand;
import org.jboss.unit.driver.impl.pojo.POJOTestSuiteInfo;
import org.jboss.unit.driver.response.EndTestResponse;
import org.jboss.unit.driver.response.FailureResponse;
import org.jboss.unit.info.TestInfo;
import org.jboss.unit.info.TestSuiteInfo;
import org.jboss.unit.spi.pojo.TestCase;
import org.jboss.unit.spi.pojo.TestCaseLifeCycleException;
import org.jboss.unit.spi.pojo.TestLifeCycle;
import org.jboss.unit.spi.pojo.TestProvider;
import org.jboss.unit.spi.pojo.TestProviderSupport;
import org.jboss.unit.spi.pojo.annotations.Provider;

public class POJOTestSuiteDriver
extends AbstractTestDriver {
    private TestProvider provider;
    private TestSuiteInfo info;

    public POJOTestSuiteDriver(Class testClass) throws InstantiationException, IllegalAccessException {
        Provider provider = testClass.getAnnotation(Provider.class);
        if (provider == null) {
            Annotation annotation;
            Class<? extends Annotation> blah;
            Annotation[] arr$ = testClass.getAnnotations();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (provider = (blah = (annotation = arr$[i$]).annotationType()).getAnnotation((Class<? extends Annotation>)Provider.class)) == null; ++i$) {
            }
        }
        if (provider != null) {
            try {
                Class<? extends TestProvider> providerClass = provider.value();
                Constructor<? extends TestProvider> providerCtor = providerClass.getConstructor(Class.class);
                this.provider = providerCtor.newInstance(testClass);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            this.provider = new TestProviderSupport(testClass);
        }
        this.info = new POJOTestSuiteInfo(this.provider.getDescriptor());
    }

    public TestInfo getInfo() {
        return this.info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DriverResponse invoke(TestId id, DriverCommand command) {
        if (command instanceof StartTestCommand) {
            TestCase testCase;
            StartTestCommand start = (StartTestCommand)command;
            if (id.getLength() == 0) {
                throw new IllegalArgumentException();
            }
            TestLifeCycle lifeCycle = this.provider.getLifeCycle();
            String name = id.getName(0);
            try {
                testCase = lifeCycle.newTestCase(name);
            }
            catch (Exception e) {
                return this.createResponse(e);
            }
            Map<String, String> parametrization = start.getParametrization();
            try {
                lifeCycle.testCaseParametrize(testCase, parametrization);
            }
            catch (Exception e) {
                return this.createResponse(e);
            }
            try {
                lifeCycle.testCaseCreate(testCase);
                lifeCycle.testCaseInvoke(testCase);
            }
            catch (Exception e) {
                DriverResponse driverResponse = this.createResponse(e);
                return driverResponse;
            }
            finally {
                lifeCycle.testCaseDestroy(testCase);
            }
            return new EndTestResponse();
        }
        throw new IllegalArgumentException();
    }

    private DriverResponse createResponse(Throwable t) {
        if (t instanceof TestCaseLifeCycleException && t.getCause() != null) {
            t = t.getCause();
        }
        return new FailureResponse(Failure.createFailure(t));
    }
}

