/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.runner.impl.generic;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.jboss.unit.Failure;
import org.jboss.unit.TestId;
import org.jboss.unit.driver.TestDriver;
import org.jboss.unit.runner.AbstractTestRunner;
import org.jboss.unit.runner.ParametrizationSet;
import org.jboss.unit.runner.TestRunnerContext;
import org.jboss.unit.runner.event.RunnerFailureEvent;
import org.jboss.unit.runner.impl.DelegateRunnerEventFilter;
import org.jboss.unit.runner.impl.TestRunnerContextSupport;
import org.jboss.unit.runner.impl.driver.TestDriverRunner;
import org.jboss.unit.runner.model.generic.GenericTestSuiteDef;
import org.jboss.unit.runner.model.generic.TestDef;

public class GenericTestRunner
extends AbstractTestRunner {
    private final GenericTestSuiteDef def;

    public GenericTestRunner(GenericTestSuiteDef def) {
        this.def = def;
    }

    protected void internalRun(TestRunnerContext context) {
        String className = this.def.getClassName();
        DelegateRunnerEventFilter filter = new DelegateRunnerEventFilter(context.getEventListener());
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            TestDriver driver = (TestDriver)clazz.newInstance();
            Collection<TestDef> testDefs = this.def.getTests();
            if (testDefs.isEmpty()) {
                testDefs = Collections.singleton(new TestDef(new TestId()));
            }
            HashMap<String, String> properties = new HashMap<String, String>(this.def.getProperties());
            properties.putAll(context.getProperties());
            for (TestDef testDef : testDefs) {
                ParametrizationSet parametrizations = this.def.getParameters().getParametrization().clone();
                parametrizations.combine(testDef.getParameters().getParametrization());
                parametrizations.combine(context.getParametrizations());
                TestRunnerContextSupport genericContext = new TestRunnerContextSupport(properties, parametrizations, context.getFilter(), filter);
                TestDriverRunner runner = new TestDriverRunner(driver, testDef.getRefId());
                runner.run(genericContext);
            }
        }
        catch (Exception e) {
            context.getEventListener().onEvent(new RunnerFailureEvent(Failure.createFailure("Cannot execute test class " + className, e)));
        }
    }
}

