/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.util;

import java.util.ArrayList;
import java.util.Collection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLTools {
    public static Collection<Element> children(Element element, String ... names) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        if (names == null) {
            throw new IllegalArgumentException();
        }
        NodeList childNodes = element.getChildNodes();
        ArrayList<Element> childElements = new ArrayList<Element>(childNodes.getLength());
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1) continue;
            String childName = childNode.getNodeName();
            if (names.length == 0) {
                childElements.add((Element)childNode);
                continue;
            }
            for (String name : names) {
                if (!childName.equals(name)) continue;
                childElements.add((Element)childNode);
            }
        }
        return childElements;
    }

    public static Element child(Element element, String name) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        if (name == null) {
            throw new IllegalArgumentException();
        }
        NodeList childNodes = element.getChildNodes();
        Element childElement = null;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1 || !name.equals(childNode.getNodeName())) continue;
            if (childElement != null) {
                throw new IllegalArgumentException();
            }
            childElement = (Element)childNode;
        }
        return childElement;
    }

    public static String text(Element element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        NodeList childNodes = element.getChildNodes();
        StringBuffer tmp = new StringBuffer();
        block4: for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            switch (childNode.getNodeType()) {
                case 3: {
                    Text text = (Text)childNode;
                    tmp.append(text.getData());
                    continue block4;
                }
                case 1: {
                    throw new IllegalArgumentException();
                }
            }
        }
        return tmp.toString();
    }
}

