/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.ProducerMethod;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.ejb.EjbDescriptors;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldMethod;

public final class BeansClosure {
    private final Map<Bean<?>, Bean<?>> specialized = new ConcurrentHashMap();
    private final Map<BeanDeployerEnvironment, Object> envs = new ConcurrentHashMap<BeanDeployerEnvironment, Object>();

    public void addSpecialized(Bean<?> specializedBean, Bean<?> specializingBean) {
        this.specialized.put(specializedBean, specializingBean);
    }

    public void addEnvironment(BeanDeployerEnvironment environment) {
        this.envs.put(environment, Object.class);
    }

    public void clear() {
        this.envs.clear();
    }

    public void destroy() {
        this.specialized.clear();
    }

    @Deprecated
    public Map getSpecialized() {
        return Collections.unmodifiableMap(this.specialized);
    }

    public Bean<?> getSpecializingBean(Bean<?> bean) {
        return this.specialized.get(bean);
    }

    public boolean isSpecialized(Bean<?> bean) {
        return this.getSpecializingBean(bean) != null;
    }

    public Bean<?> getMostSpecializingBean(Bean<?> bean) {
        Bean<?> most = bean;
        while (most != null) {
            Bean<?> temp = most;
            most = this.getSpecializingBean(bean);
            bean = temp;
        }
        return bean;
    }

    public boolean isEJB(WeldClass<?> clazz) {
        for (BeanDeployerEnvironment bde : this.getEnvironments()) {
            EjbDescriptors ed = bde.getEjbDescriptors();
            if (!ed.contains(clazz.getJavaClass())) continue;
            return true;
        }
        return false;
    }

    public Bean<?> getClassBean(WeldClass<?> clazz) {
        for (BeanDeployerEnvironment bde : this.getEnvironments()) {
            AbstractClassBean<?> classBean = bde.getClassBean(clazz);
            if (classBean == null) continue;
            return classBean;
        }
        return null;
    }

    public ProducerMethod<?, ?> getProducerMethod(WeldMethod<?, ?> superClassMethod) {
        for (BeanDeployerEnvironment bde : this.getEnvironments()) {
            ProducerMethod<?, ?> pm = bde.getProducerMethod(superClassMethod);
            if (pm == null) continue;
            return pm;
        }
        return null;
    }

    private Set<BeanDeployerEnvironment> getEnvironments() {
        return this.envs.keySet();
    }
}

