/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se.discovery.url;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemURLHandler {
    private static final Logger log = LoggerFactory.getLogger(FileSystemURLHandler.class);

    public void handle(Collection<String> paths, List<String> discoveredClasses, List<URL> discoveredBeansXmlUrls) {
        for (String urlPath : paths) {
            try {
                File file;
                log.trace("scanning: " + urlPath);
                if (urlPath.startsWith("file:")) {
                    urlPath = urlPath.substring(5);
                }
                if (urlPath.indexOf(33) > 0) {
                    urlPath = urlPath.substring(0, urlPath.indexOf(33));
                }
                if ((file = new File(urlPath)).isDirectory()) {
                    this.handleDirectory(file, null, discoveredClasses, discoveredBeansXmlUrls);
                    continue;
                }
                this.handleArchiveByFile(file, discoveredClasses, discoveredBeansXmlUrls);
            }
            catch (IOException ioe) {
                log.warn("could not read entries", ioe);
            }
        }
    }

    private void handleArchiveByFile(File file, List<String> discoveredClasses, List<URL> discoveredBeansXmlUrls) throws IOException {
        try {
            log.trace("archive: " + file);
            String archiveUrl = "jar:" + file.toURI().toURL().toExternalForm() + "!/";
            ZipFile zip = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                this.handle(name, new URL(archiveUrl + name), discoveredClasses, discoveredBeansXmlUrls);
            }
        }
        catch (ZipException e) {
            throw new RuntimeException("Error handling file " + file, e);
        }
    }

    protected void handleDirectory(File file, String path, List<String> discoveredClasses, List<URL> discoveredBeansXmlUrls) {
        this.handleDirectory(file, path, new File[0], discoveredClasses, discoveredBeansXmlUrls);
    }

    private void handleDirectory(File file, String path, File[] excludedDirectories, List<String> discoveredClasses, List<URL> discoveredBeansXmlUrls) {
        for (File excludedDirectory : excludedDirectories) {
            if (!file.equals(excludedDirectory)) continue;
            log.trace("skipping excluded directory: " + file);
            return;
        }
        log.trace("handling directory: " + file);
        for (File child : file.listFiles()) {
            String newPath;
            String string = newPath = path == null ? child.getName() : path + '/' + child.getName();
            if (child.isDirectory()) {
                this.handleDirectory(child, newPath, excludedDirectories, discoveredClasses, discoveredBeansXmlUrls);
                continue;
            }
            try {
                this.handle(newPath, child.toURI().toURL(), discoveredClasses, discoveredBeansXmlUrls);
            }
            catch (MalformedURLException e) {
                log.error("Error loading file " + newPath);
            }
        }
    }

    protected void handle(String name, URL url, List<String> discoveredClasses, List<URL> discoveredBeansXmlUrls) {
        if (name.endsWith(".class")) {
            discoveredClasses.add(FileSystemURLHandler.filenameToClassname(name));
        } else if (name.endsWith("beans.xml")) {
            discoveredBeansXmlUrls.add(url);
        }
    }

    public static String filenameToClassname(String filename) {
        return filename.substring(0, filename.lastIndexOf(".class")).replace('/', '.').replace('\\', '.');
    }
}

