/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.manager;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.Transform;

public class BeanManagers {
    private BeanManagers() {
    }

    public static Set<Iterable<BeanManagerImpl>> getAccessibleClosure(BeanManagerImpl beanManager) {
        HashSet<Iterable<BeanManagerImpl>> beanManagers = new HashSet<Iterable<BeanManagerImpl>>();
        beanManagers.add(Collections.singleton(beanManager));
        beanManagers.addAll(BeanManagers.buildAccessibleClosure(beanManager, BeanManagerTransform.INSTANCE));
        return beanManagers;
    }

    public static <T> Set<Iterable<T>> buildAccessibleClosure(BeanManagerImpl beanManager, Transform<T> transform) {
        HashSet<Iterable<T>> result = new HashSet<Iterable<T>>();
        BeanManagers.buildAccessibleClosure(beanManager, result, new HashSet<BeanManagerImpl>(), transform);
        return result;
    }

    private static <T> void buildAccessibleClosure(BeanManagerImpl beanManager, Set<Iterable<T>> result, Collection<BeanManagerImpl> hierarchy, Transform<T> transform) {
        hierarchy.add(beanManager);
        result.add(transform.transform(beanManager));
        for (BeanManagerImpl accessibleBeanManager : beanManager.getAccessibleManagers()) {
            if (hierarchy.contains(accessibleBeanManager)) continue;
            BeanManagers.buildAccessibleClosure(accessibleBeanManager, result, hierarchy, transform);
        }
    }

    private static class BeanManagerTransform
    implements Transform<BeanManagerImpl> {
        public static final BeanManagerTransform INSTANCE = new BeanManagerTransform();

        private BeanManagerTransform() {
        }

        @Override
        public Iterable<BeanManagerImpl> transform(BeanManagerImpl beanManager) {
            return beanManager.getAccessibleManagers();
        }
    }
}

