package org.jboss.weld.environment.servlet.logging;

import org.jboss.weld.environment.logging.WeldEnvironmentLogger;
import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import java.lang.RuntimeException;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import org.jboss.logging.Logger;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2021-03-18T12:43:09+0100")
public class WeldServletLogger_$logger extends DelegatingBasicLogger implements WeldServletLogger, WeldEnvironmentLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = WeldServletLogger_$logger.class.getName();
    public WeldServletLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void resourceInjectionNotAvailable() {
        super.log.logf(FQCN, WARN, null, resourceInjectionNotAvailable$str());
    }
    protected String resourceInjectionNotAvailable$str() {
        return "WELD-ENV-001000: @Resource injection not available in simple beans";
    }
    @Override
    public final void noSupportedServletContainerDetected() {
        super.log.logf(FQCN, INFO, null, noSupportedServletContainerDetected$str());
    }
    protected String noSupportedServletContainerDetected$str() {
        return "WELD-ENV-001001: No supported servlet container detected, CDI injection will NOT be available in Servlets, Filters or Listeners";
    }
    @Override
    public final void containerDetectionSkipped(final Object param1) {
        super.log.logv(FQCN, INFO, null, containerDetectionSkipped$str(), param1);
    }
    protected String containerDetectionSkipped$str() {
        return "WELD-ENV-001002: Container detection skipped - custom container class loaded: {0}.";
    }
    @Override
    public final void unableToInstantiateCustomContainerClass(final Object param1) {
        super.log.logv(FQCN, WARN, null, unableToInstantiateCustomContainerClass$str(), param1);
    }
    protected String unableToInstantiateCustomContainerClass$str() {
        return "WELD-ENV-001003: Unable to instantiate custom container class: {0}.";
    }
    @Override
    public final void foundBothConfiguration(final Object param1) {
        super.log.logv(FQCN, WARN, null, foundBothConfiguration$str(), param1);
    }
    protected String foundBothConfiguration$str() {
        return "WELD-ENV-001004: Found both WEB-INF/beans.xml and WEB-INF/classes/META-INF/beans.xml. It is not portable to use both locations at the same time. Weld is going to use: {0}";
    }
    @Override
    public final void enhancedListenerUsedForNotifications() {
        super.log.logf(FQCN, INFO, null, enhancedListenerUsedForNotifications$str());
    }
    protected String enhancedListenerUsedForNotifications$str() {
        return "WELD-ENV-001006: org.jboss.weld.environment.servlet.EnhancedListener used to initialize Weld";
    }
    @Override
    public final void initializeWeldUsingServletContextListener() {
        super.log.logf(FQCN, INFO, null, initializeWeldUsingServletContextListener$str());
    }
    protected String initializeWeldUsingServletContextListener$str() {
        return "WELD-ENV-001007: Initialize Weld using ServletContextListener";
    }
    @Override
    public final void initializeWeldUsingServletContainerInitializer() {
        super.log.logf(FQCN, INFO, null, initializeWeldUsingServletContainerInitializer$str());
    }
    protected String initializeWeldUsingServletContainerInitializer$str() {
        return "WELD-ENV-001008: Initialize Weld using ServletContainerInitializer";
    }
    @Override
    public final void listenerUserForServletRequestAndHttpSessionNotifications() {
        super.log.logf(FQCN, INFO, null, listenerUserForServletRequestAndHttpSessionNotifications$str());
    }
    protected String listenerUserForServletRequestAndHttpSessionNotifications$str() {
        return "WELD-ENV-001009: org.jboss.weld.environment.servlet.Listener used for ServletRequest and HttpSession notifications";
    }
    @Override
    public final void problemWhenInterating(final Object param1, final Throwable cause) {
        super.log.logv(FQCN, INFO, cause, problemWhenInterating$str(), param1);
    }
    protected String problemWhenInterating$str() {
        return "WELD-ENV-001010: Problem when iterating through {0}";
    }
    @Override
    public final void couldNotReadContext(final Object param1) {
        super.log.logv(FQCN, INFO, null, couldNotReadContext$str(), param1);
    }
    protected String couldNotReadContext$str() {
        return "WELD-ENV-001011: Could not read context {0}: Trying to create it!";
    }
    @Override
    public final void beanManagerReferenceBoundTo(final Object param1) {
        super.log.logv(FQCN, INFO, null, beanManagerReferenceBoundTo$str(), param1);
    }
    protected String beanManagerReferenceBoundTo$str() {
        return "WELD-ENV-001012: BeanManager reference bound to {0}.";
    }
    @Override
    public final void successfullyUnboundBeanManagerReference() {
        super.log.logf(FQCN, INFO, null, successfullyUnboundBeanManagerReference$str());
    }
    protected String successfullyUnboundBeanManagerReference$str() {
        return "WELD-ENV-001013: Successfully unbound BeanManager reference.";
    }
    @Override
    public final void failedToUnbindBeanManagerReference() {
        super.log.logf(FQCN, WARN, null, failedToUnbindBeanManagerReference$str());
    }
    protected String failedToUnbindBeanManagerReference$str() {
        return "WELD-ENV-001014: Failed to unbind BeanManager reference!";
    }
    @Override
    public final void couldntCreateContext(final Object param1) {
        super.log.logv(FQCN, ERROR, null, couldntCreateContext$str(), param1);
    }
    protected String couldntCreateContext$str() {
        return "WELD-ENV-001015: Could not create context: {0}.";
    }
    protected String errorLoadingResources$str() {
        return "WELD-ENV-001016: Error loading resources from servlet context.";
    }
    @Override
    public final IllegalStateException errorLoadingResources(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), errorLoadingResources$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String exceptionFetchingBeanManager$str() {
        return "WELD-ENV-001017: Exception fetching BeanManager instance!";
    }
    @Override
    public final IllegalStateException exceptionFetchingBeanManager(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), exceptionFetchingBeanManager$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notInAServletOrPortlet$str() {
        return "WELD-ENV-001018: Not in a servlet or portlet environment!";
    }
    @Override
    public final IllegalStateException notInAServletOrPortlet() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), notInAServletOrPortlet$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorCreatingJNDIContext$str() {
        return "WELD-ENV-001019: Error creating JNDI context";
    }
    @Override
    public final IllegalStateException errorCreatingJNDIContext(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), errorCreatingJNDIContext$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noServiceLoaderClassAvailable$str() {
        return "WELD-ENV-001022: No ServiceLoader class available!";
    }
    @Override
    public final IllegalStateException noServiceLoaderClassAvailable() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noServiceLoaderClassAvailable$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noLoadMethodAvailableOnServiceLoader$str() {
        return "WELD-ENV-001023: No load method available on ServiceLoader - {0}.";
    }
    @Override
    public final IllegalStateException noLoadMethodAvailableOnServiceLoader(final Object param1, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(noLoadMethodAvailableOnServiceLoader$str(), param1), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private String _formatMessage(final String format, final Object... args) {
        final java.text.MessageFormat formatter = new java.text.MessageFormat(format, getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new java.text.FieldPosition(0)).toString();
    }
    protected String couldNotBindBeanManagerReferenceToJNDI$str() {
        return "WELD-ENV-001024: Could not bind BeanManager reference to JNDI: {0}\nIf the naming context is read-only, you may need to use a configuration to bind the BeanManager instead, such as Tomcat's context.xml or Jetty's jetty-web.xml.";
    }
    @Override
    public final RuntimeException couldNotBindBeanManagerReferenceToJNDI(final Object param1) {
        final RuntimeException result = new RuntimeException(_formatMessage(couldNotBindBeanManagerReferenceToJNDI$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String couldNotCreateInitialContext$str() {
        return "WELD-ENV-001025: Could not create InitialContext to bind BeanManager reference in JNDI: {0}.";
    }
    @Override
    public final RuntimeException couldNotCreateInitialContext(final Object param1) {
        final RuntimeException result = new RuntimeException(_formatMessage(couldNotCreateInitialContext$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorLoadingWeldELContextListener$str() {
        return "WELD-ENV-001028: Error loading Weld ELContext Listener, check that Weld is on the classpath.";
    }
    @Override
    public final IllegalStateException errorLoadingWeldELContextListener(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), errorLoadingWeldELContextListener$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void noServletLifecycleToDestroy() {
        super.log.logf(FQCN, WARN, null, noServletLifecycleToDestroy$str());
    }
    protected String noServletLifecycleToDestroy$str() {
        return "WELD-ENV-001029: org.jboss.weld.environment.servlet.Listener is in an inconsistent state - Weld Servlet cannot be shut down properly";
    }
    @Override
    public final void cannotHandleLibrary(final Object path, final Throwable cause) {
        super.log.logv(FQCN, ERROR, cause, cannotHandleLibrary$str(), path);
    }
    protected String cannotHandleLibrary$str() {
        return "WELD-ENV-001030: Error handling library: {0}.";
    }
    @Override
    public final void catchingDebug(final Throwable arg0) {
        super.log.logf(FQCN, DEBUG, arg0, catchingDebug$str());
    }
    protected String catchingDebug$str() {
        return "Catching";
    }
    @Override
    public final void catchingTrace(final Throwable arg0) {
        super.log.logf(FQCN, TRACE, arg0, catchingTrace$str());
    }
    protected String catchingTrace$str() {
        return "Catching";
    }
}
