package org.jboss.weld.logging;

import java.util.Locale;
import org.jboss.weld.exceptions.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import org.jboss.weld.logging.WeldLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import org.jboss.weld.exceptions.DeploymentException;
import java.lang.Class;
import org.jboss.weld.exceptions.DefinitionException;
import java.util.Arrays;
import org.jboss.weld.exceptions.IllegalArgumentException;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2021-03-18T12:30:38+0100")
public class BootstrapLogger_$logger extends DelegatingBasicLogger implements BootstrapLogger, org.jboss.weld.logging.WeldLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = BootstrapLogger_$logger.class.getName();
    public BootstrapLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void validatingBeans() {
        super.log.logf(FQCN, DEBUG, null, validatingBeans$str());
    }
    protected String validatingBeans$str() {
        return "WELD-000100: Weld initialized. Validating beans";
    }
    @Override
    public final void jtaUnavailable() {
        super.log.logf(FQCN, INFO, null, jtaUnavailable$str());
    }
    protected String jtaUnavailable$str() {
        return "WELD-000101: Transactional services not available. Injection of @Inject UserTransaction not available. Transactional observers will be invoked synchronously.";
    }
    @Override
    public final void enabledAlternatives(final Object param1, final Object param2) {
        super.log.logv(FQCN, DEBUG, null, enabledAlternatives$str(), param1, param2);
    }
    protected String enabledAlternatives$str() {
        return "WELD-000103: Enabled alternatives for {0}: {1}";
    }
    @Override
    public final void enabledDecorators(final Object param1, final Object param2) {
        super.log.logv(FQCN, DEBUG, null, enabledDecorators$str(), param1, param2);
    }
    protected String enabledDecorators$str() {
        return "WELD-000104: Enabled decorator types for {0}: {1}";
    }
    @Override
    public final void enabledInterceptors(final Object param1, final Object param2) {
        super.log.logv(FQCN, DEBUG, null, enabledInterceptors$str(), param1, param2);
    }
    protected String enabledInterceptors$str() {
        return "WELD-000105: Enabled interceptor types for {0}: {1}";
    }
    @Override
    public final void foundBean(final Object param1) {
        super.log.logv(FQCN, DEBUG, null, foundBean$str(), param1);
    }
    protected String foundBean$str() {
        return "WELD-000106: Bean: {0}";
    }
    @Override
    public final void foundInterceptor(final Object param1) {
        super.log.logv(FQCN, DEBUG, null, foundInterceptor$str(), param1);
    }
    protected String foundInterceptor$str() {
        return "WELD-000107: Interceptor: {0}";
    }
    @Override
    public final void foundDecorator(final Object param1) {
        super.log.logv(FQCN, DEBUG, null, foundDecorator$str(), param1);
    }
    protected String foundDecorator$str() {
        return "WELD-000108: Decorator: {0}";
    }
    @Override
    public final void foundObserverMethod(final Object param1) {
        super.log.logv(FQCN, DEBUG, null, foundObserverMethod$str(), param1);
    }
    protected String foundObserverMethod$str() {
        return "WELD-000109: ObserverMethod: {0}";
    }
    protected String annotationTypeNull$str() {
        return "WELD-000110: Cannot set the annotation type to null (if you want to stop the type being used, call veto()):  {0}";
    }
    @Override
    public final IllegalArgumentException annotationTypeNull(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(annotationTypeNull$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private String _formatMessage(final String format, final Object... args) {
        final java.text.MessageFormat formatter = new java.text.MessageFormat(format, getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new java.text.FieldPosition(0)).toString();
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String beanTypeNotEjb$str() {
        return "WELD-000111: Bean type is not STATELESS, STATEFUL or SINGLETON:  {0}";
    }
    @Override
    public final IllegalStateException beanTypeNotEjb(final Object param1) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(beanTypeNotEjb$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String beanIsBothInterceptorAndDecorator$str() {
        return "WELD-000112: Class {0} has both @Interceptor and @Decorator annotations";
    }
    @Override
    public final DefinitionException beanIsBothInterceptorAndDecorator(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(beanIsBothInterceptorAndDecorator$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String deploymentArchiveNull$str() {
        return "WELD-000113: BeanDeploymentArchive must not be null:  {0}";
    }
    @Override
    public final IllegalArgumentException deploymentArchiveNull(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(deploymentArchiveNull$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String deploymentRequired$str() {
        return "WELD-000114: Must start the container with a deployment";
    }
    @Override
    public final IllegalArgumentException deploymentRequired() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), deploymentRequired$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String managerNotInitialized$str() {
        return "WELD-000116: Manager has not been initialized";
    }
    @Override
    public final IllegalStateException managerNotInitialized() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), managerNotInitialized$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unspecifiedRequiredService$str() {
        return "WELD-000117: Required service {0} has not been specified for {1}";
    }
    @Override
    public final IllegalStateException unspecifiedRequiredService(final Object service, final Object target) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(unspecifiedRequiredService$str(), service, target));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String passivatingNonNormalScopeIllegal$str() {
        return "WELD-000118: Only normal scopes can be passivating. Scope {0}";
    }
    @Override
    public final DefinitionException passivatingNonNormalScopeIllegal(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(passivatingNonNormalScopeIllegal$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void ignoringClassDueToLoadingError(final Object param1, final Object param2) {
        super.log.logv(FQCN, INFO, null, ignoringClassDueToLoadingError$str(), param1, param2);
    }
    protected String ignoringClassDueToLoadingError$str() {
        return "WELD-000119: Not generating any bean definitions from {0} because of underlying class loading error: Type {1} not found.  If this is unexpected, enable DEBUG logging to see the full error.";
    }
    protected String errorLoadingBeansXmlEntry$str() {
        return "WELD-000123: Error loading {0} defined in {1}";
    }
    @Override
    public final DeploymentException errorLoadingBeansXmlEntry(final Object param1, final Object param2, final Throwable cause) {
        final DeploymentException result = new DeploymentException(_formatMessage(errorLoadingBeansXmlEntry$str(), param1, param2), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void threadsInUse(final Object param1) {
        super.log.logv(FQCN, DEBUG, null, threadsInUse$str(), param1);
    }
    protected String threadsInUse$str() {
        return "WELD-000124: Using {0} threads for bootstrap";
    }
    protected String invalidThreadPoolSize$str() {
        return "WELD-000125: Invalid thread pool size: {0}";
    }
    @Override
    public final DeploymentException invalidThreadPoolSize(final Object param1) {
        final DeploymentException result = new DeploymentException(_formatMessage(invalidThreadPoolSize$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void timeoutShuttingDownThreadPool(final Object param1, final Object param2) {
        super.log.logv(FQCN, WARN, null, timeoutShuttingDownThreadPool$str(), param1, param2);
    }
    protected String timeoutShuttingDownThreadPool$str() {
        return "WELD-000126: Timeout shutting down thread pool {0} at {1}";
    }
    protected String invalidThreadPoolType$str() {
        return "WELD-000127: Invalid thread pool type: {0}";
    }
    @Override
    public final DeploymentException invalidThreadPoolType(final Object param1) {
        final DeploymentException result = new DeploymentException(_formatMessage(invalidThreadPoolType$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidPropertyValue$str() {
        return "WELD-000128: Invalid value for property {0}: {1}";
    }
    @Override
    public final DeploymentException invalidPropertyValue(final Object param1, final Object param2) {
        final DeploymentException result = new DeploymentException(_formatMessage(invalidPropertyValue$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String annotatedTypeJavaClassMismatch$str() {
        return "WELD-000130: Cannot replace AnnotatedType for {0} with AnnotatedType for {1}";
    }
    @Override
    public final IllegalArgumentException annotatedTypeJavaClassMismatch(final Object param1, final Object param2) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(annotatedTypeJavaClassMismatch$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void foundDisabledAlternative(final Object param1) {
        super.log.logv(FQCN, DEBUG, null, foundDisabledAlternative$str(), param1);
    }
    protected String foundDisabledAlternative$str() {
        return "WELD-000132: Disabled alternative (ignored): {0}";
    }
    @Override
    public final void foundSpecializedBean(final Object param1) {
        super.log.logv(FQCN, DEBUG, null, foundSpecializedBean$str(), param1);
    }
    protected String foundSpecializedBean$str() {
        return "WELD-000133: Specialized bean (ignored): {0}";
    }
    @Override
    public final void foundProducerOfSpecializedBean(final Object param1) {
        super.log.logv(FQCN, DEBUG, null, foundProducerOfSpecializedBean$str(), param1);
    }
    protected String foundProducerOfSpecializedBean$str() {
        return "WELD-000134: Producer (method or field) of specialized bean (ignored): {0}";
    }
    @Override
    public final void legacyDeploymentMetadataProvided() {
        super.log.logf(FQCN, WARN, null, legacyDeploymentMetadataProvided$str());
    }
    protected String legacyDeploymentMetadataProvided$str() {
        return "WELD-000135: Legacy deployment metadata provided by the integrator. Certain functionality will not be available.";
    }
    @Override
    public final void exceptionThrownDuringBeforeShutdownObserver() {
        super.log.logf(FQCN, ERROR, null, exceptionThrownDuringBeforeShutdownObserver$str());
    }
    protected String exceptionThrownDuringBeforeShutdownObserver$str() {
        return "WELD-000136: Exception(s) thrown during observer of BeforeShutdown: ";
    }
    @Override
    public final void exceptionWhileLoadingClass(final Object param1, final Object param2) {
        super.log.logv(FQCN, TRACE, null, exceptionWhileLoadingClass$str(), param1, param2);
    }
    protected String exceptionWhileLoadingClass$str() {
        return "WELD-000137: Exception while loading class '{0}' : {1}";
    }
    @Override
    public final void errorWhileLoadingClass(final Object param1, final Object param2) {
        super.log.logv(FQCN, TRACE, null, errorWhileLoadingClass$str(), param1, param2);
    }
    protected String errorWhileLoadingClass$str() {
        return "WELD-000138: Error while loading class '{0}' : {1}";
    }
    @Override
    public final void ignoringExtensionClassDueToLoadingError(final String className, final String missingDependency) {
        super.log.logv(FQCN, WARN, null, ignoringExtensionClassDueToLoadingError$str(), className, missingDependency);
    }
    protected String ignoringExtensionClassDueToLoadingError$str() {
        return "WELD-000139: Ignoring portable extension class {0} because of underlying class loading error: Type {1} not found. Enable DEBUG logging level to see the full error.";
    }
    protected String callingBootstrapMethodAfterContainerHasBeenInitialized$str() {
        return "WELD-000140: Calling Bootstrap method after container has already been initialized. For correct order, see CDI11Bootstrap's documentation.";
    }
    @Override
    public final IllegalStateException callingBootstrapMethodAfterContainerHasBeenInitialized() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), callingBootstrapMethodAfterContainerHasBeenInitialized$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void notUsingFastResolver(final ObserverMethod<?> observer) {
        super.log.logv(FQCN, INFO, null, notUsingFastResolver$str(), observer);
    }
    protected String notUsingFastResolver$str() {
        return "WELD-000141: Falling back to the default observer method resolver due to {0}";
    }
    @Override
    public final void exceptionLoadingAnnotatedType(final String message) {
        super.log.logv(FQCN, DEBUG, null, exceptionLoadingAnnotatedType$str(), message);
    }
    protected String exceptionLoadingAnnotatedType$str() {
        return "WELD-000142: Exception loading annotated type using ClassFileServices. Falling back to the default implementation. {0}";
    }
    @Override
    public final void patSkipped(final SlimAnnotatedType<?> type) {
        super.log.logv(FQCN, TRACE, null, patSkipped$str(), type);
    }
    protected String patSkipped$str() {
        return "No PAT observers resolved for {0}. Skipping.";
    }
    @Override
    public final void patDefaultResolver(final SlimAnnotatedType<?> type) {
        super.log.logv(FQCN, TRACE, null, patDefaultResolver$str(), type);
    }
    protected String patDefaultResolver$str() {
        return "Sending PAT using the default event resolver: {0}";
    }
    @Override
    public final void patFastResolver(final SlimAnnotatedType<?> type) {
        super.log.logv(FQCN, TRACE, null, patFastResolver$str(), type);
    }
    protected String patFastResolver$str() {
        return "Sending PAT using the fast event resolver: {0}";
    }
    protected String containerLifecycleEventMethodInvokedOutsideObserver$str() {
        return "WELD-000143: Container lifecycle event method invoked outside of extension observer method invocation.";
    }
    @Override
    public final IllegalStateException containerLifecycleEventMethodInvokedOutsideObserver() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), containerLifecycleEventMethodInvokedOutsideObserver$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cdiApiVersionMismatch$str() {
        return "WELD-000144: CDI API version mismatch. CDI 1.0 API detected on classpath. Weld requires version 1.1 or better.";
    }
    @Override
    public final IllegalStateException cdiApiVersionMismatch() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cdiApiVersionMismatch$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void beanIdentifierIndexBuilt(final Object info) {
        super.log.logv(FQCN, DEBUG, null, beanIdentifierIndexBuilt$str(), info);
    }
    protected String beanIdentifierIndexBuilt$str() {
        return "WELD-000145: Bean identifier index built:\n  {0}";
    }
    @Override
    public final void deprecatedAddAnnotatedTypeMethodUsed(final Class<?> clazz) {
        super.log.logv(FQCN, WARN, null, deprecatedAddAnnotatedTypeMethodUsed$str(), clazz);
    }
    protected String deprecatedAddAnnotatedTypeMethodUsed$str() {
        return "WELD-000146: BeforeBeanDiscovery.addAnnotatedType(AnnotatedType<?>) used for {0} is deprecated from CDI 1.1!";
    }
    @Override
    public final void decoratorWithNonCdiConstructor(final String clazzName) {
        super.log.logv(FQCN, WARN, null, decoratorWithNonCdiConstructor$str(), clazzName);
    }
    protected String decoratorWithNonCdiConstructor$str() {
        return "WELD-000147: Decorator {0} declares inappropriate constructor therefore will not available as a managed bean!";
    }
    @Override
    public final void setAnnotatedTypeCalled(final Object extensionName, final Object original, final Object newer) {
        super.log.logv(FQCN, DEBUG, null, setAnnotatedTypeCalled$str(), extensionName, original, newer);
    }
    protected String setAnnotatedTypeCalled$str() {
        return "WELD-000148: ProcessAnnotatedType.setAnnotatedType() called by {0}: {1} replaced by {2}";
    }
    @Override
    public final void setBeanAttributesCalled(final Object extensionName, final Object original, final Object newer) {
        super.log.logv(FQCN, DEBUG, null, setBeanAttributesCalled$str(), extensionName, original, newer);
    }
    protected String setBeanAttributesCalled$str() {
        return "WELD-000149: ProcessBeanAttributes.setBeanAttributes() called by {0}: {1} replaced by {2}";
    }
    @Override
    public final void setInjectionPointCalled(final Object extensionName, final Object original, final Object newer) {
        super.log.logv(FQCN, DEBUG, null, setInjectionPointCalled$str(), extensionName, original, newer);
    }
    protected String setInjectionPointCalled$str() {
        return "WELD-000150: ProcessInjectionPoint.setInjectionPoint() called by {0}: {1} replaced by {2}";
    }
    @Override
    public final void setInjectionTargetCalled(final Object extensionName, final Object original, final Object newer) {
        super.log.logv(FQCN, DEBUG, null, setInjectionTargetCalled$str(), extensionName, original, newer);
    }
    protected String setInjectionTargetCalled$str() {
        return "WELD-000151: ProcessInjectionTarget.setInjectionTarget() called by {0}: {1} replaced by {2}";
    }
    @Override
    public final void setProducerCalled(final Object extensionName, final Object original, final Object newer) {
        super.log.logv(FQCN, DEBUG, null, setProducerCalled$str(), extensionName, original, newer);
    }
    protected String setProducerCalled$str() {
        return "WELD-000152: ProcessProducer.setProducer() called by {0}: {1} replaced by {2}";
    }
    @Override
    public final void addAnnotatedTypeCalled(final Object extensionName, final Object type) {
        super.log.logv(FQCN, DEBUG, null, addAnnotatedTypeCalled$str(), extensionName, type);
    }
    protected String addAnnotatedTypeCalled$str() {
        return "WELD-000153: AfterTypeDiscovery.addAnnotatedType() called by {0} for {1}";
    }
    @Override
    public final void addBeanCalled(final Object extensionName, final Object type) {
        super.log.logv(FQCN, DEBUG, null, addBeanCalled$str(), extensionName, type);
    }
    protected String addBeanCalled$str() {
        return "WELD-000154: AfterBeanDiscovery.addBean() called by {0} for {1}";
    }
    @Override
    public final void addObserverMethodCalled(final Object extensionName, final Object type) {
        super.log.logv(FQCN, DEBUG, null, addObserverMethodCalled$str(), extensionName, type);
    }
    protected String addObserverMethodCalled$str() {
        return "WELD-000155: AfterBeanDiscovery.addObserverMethod() called by {0} for {1}";
    }
    @Override
    public final void addContext(final Object extensionName, final Object type) {
        super.log.logv(FQCN, DEBUG, null, addContext$str(), extensionName, type);
    }
    protected String addContext$str() {
        return "WELD-000156: AfterBeanDiscovery.addContext() called by {0} for {1}";
    }
    @Override
    public final void addDefinitionErrorCalled(final Object extensionName, final Object type) {
        super.log.logv(FQCN, DEBUG, null, addDefinitionErrorCalled$str(), extensionName, type);
    }
    protected String addDefinitionErrorCalled$str() {
        return "WELD-000157: AfterBeanDiscovery.addDefinitionError() called by {0} for {1}";
    }
    @Override
    public final void addQualifierCalled(final Object extensionName, final Object type) {
        super.log.logv(FQCN, DEBUG, null, addQualifierCalled$str(), extensionName, type);
    }
    protected String addQualifierCalled$str() {
        return "WELD-000158: BeforeBeanDiscovery.addQualifier() called by {0} for {1}";
    }
    @Override
    public final void addScopeCalled(final Object extensionName, final Object type) {
        super.log.logv(FQCN, DEBUG, null, addScopeCalled$str(), extensionName, type);
    }
    protected String addScopeCalled$str() {
        return "WELD-000159: BeforeBeanDiscovery.addScope() called by {0} for {1}";
    }
    @Override
    public final void addStereoTypeCalled(final Object extensionName, final Object type) {
        super.log.logv(FQCN, DEBUG, null, addStereoTypeCalled$str(), extensionName, type);
    }
    protected String addStereoTypeCalled$str() {
        return "WELD-000160: BeforeBeanDiscovery.addStereoType() called by {0} for {1}";
    }
    @Override
    public final void addInterceptorBindingCalled(final Object extensionName, final Object type) {
        super.log.logv(FQCN, DEBUG, null, addInterceptorBindingCalled$str(), extensionName, type);
    }
    protected String addInterceptorBindingCalled$str() {
        return "WELD-000161: BeforeBeanDiscovery.addInterceptorBindingCalled() called by {0} for {1}";
    }
    @Override
    public final void addAnnotatedTypeCalledInBBD(final Object extensionName, final Object type) {
        super.log.logv(FQCN, DEBUG, null, addAnnotatedTypeCalledInBBD$str(), extensionName, type);
    }
    protected String addAnnotatedTypeCalledInBBD$str() {
        return "WELD-000162: BeforeBeanDiscovery.addAnnotatedType() called by {0} for {1}";
    }
    protected String nonuniqueBeanDeploymentIdentifier$str() {
        return "WELD-000163: Non-unique bean deployment identifier detected: {0}";
    }
    @Override
    public final DeploymentException nonuniqueBeanDeploymentIdentifier(final Object info) {
        final DeploymentException result = new DeploymentException(_formatMessage(nonuniqueBeanDeploymentIdentifier$str(), info));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void annotatedTypeVetoed(final Object extensionName, final Object type) {
        super.log.logv(FQCN, DEBUG, null, annotatedTypeVetoed$str(), extensionName, type);
    }
    protected String annotatedTypeVetoed$str() {
        return "WELD-000164: ProcessAnnotatedType.veto() called by {0} for {1}";
    }
    @Override
    public final void beanAttributesVetoed(final Object extensionName, final Object type) {
        super.log.logv(FQCN, DEBUG, null, beanAttributesVetoed$str(), extensionName, type);
    }
    protected String beanAttributesVetoed$str() {
        return "WELD-000165: ProcessBeanAttributes.veto() called by {0} for {1}";
    }
    @Override
    public final void typeModifiedInAfterTypeDiscovery(final Object extensionName, final Object type, final Object operation, final Object types) {
        super.log.logv(FQCN, DEBUG, null, typeModifiedInAfterTypeDiscovery$str(), extensionName, type, operation, types);
    }
    protected String typeModifiedInAfterTypeDiscovery$str() {
        return "WELD-000166: AfterTypeDiscovery.{3} modified by {0} {2} {1}";
    }
    @Override
    public final void annotatedTypeNotRegisteredAsBeanDueToMissingAppropriateConstructor(final String clazzName, final String annotationName) {
        super.log.logv(FQCN, WARN, null, annotatedTypeNotRegisteredAsBeanDueToMissingAppropriateConstructor$str(), clazzName, annotationName);
    }
    protected String annotatedTypeNotRegisteredAsBeanDueToMissingAppropriateConstructor$str() {
        return "WELD-000167: Class {0} is annotated with @{1} but it does not declare an appropriate constructor therefore is not registered as a bean!";
    }
    @Override
    public final void extensionBeanDeployed(final Object extension) {
        super.log.logv(FQCN, DEBUG, null, extensionBeanDeployed$str(), extension);
    }
    protected String extensionBeanDeployed$str() {
        return "WELD-000168: Extension bean deployed: {0}";
    }
    @Override
    public final void usingOldJandexVersion() {
        super.log.logv(FQCN, INFO, null, usingOldJandexVersion$str());
    }
    protected String usingOldJandexVersion$str() {
        return "WELD-000169: Jandex cannot distinguish inner and static nested classes! Update Jandex to 2.0.3.Final version or newer to improve scanning performance.";
    }
    protected String configuratorAndSetMethodBothCalled$str() {
        return "WELD-000170: {0} observer cannot call both the configurator and set methods. Extension {1} \nStackTrace:";
    }
    @Override
    public final IllegalStateException configuratorAndSetMethodBothCalled(final Object observerName, final Object extension) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(configuratorAndSetMethodBothCalled$str(), observerName, extension));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void configureQualifierCalled(final Object extensionName, final Object type) {
        super.log.logv(FQCN, DEBUG, null, configureQualifierCalled$str(), extensionName, type);
    }
    protected String configureQualifierCalled$str() {
        return "WELD-000171: BeforeBeanDiscovery.configureQualifier() called by {0} for {1}";
    }
    @Override
    public final void configureInterceptorBindingCalled(final Object extensionName, final Object type) {
        super.log.logv(FQCN, DEBUG, null, configureInterceptorBindingCalled$str(), extensionName, type);
    }
    protected String configureInterceptorBindingCalled$str() {
        return "WELD-000172: BeforeBeanDiscovery.configureInterceptorBinding() called by {0} for {1}";
    }
    @Override
    public final void configureProducerCalled(final Object extensionName, final Object bean) {
        super.log.logv(FQCN, DEBUG, null, configureProducerCalled$str(), extensionName, bean);
    }
    protected String configureProducerCalled$str() {
        return "WELD-000173: ProcessProducer.configureProducer() called by {0} for {1}";
    }
    @Override
    public final void configureBeanAttributesCalled(final Object extensionName, final Object bean) {
        super.log.logv(FQCN, DEBUG, null, configureBeanAttributesCalled$str(), extensionName, bean);
    }
    protected String configureBeanAttributesCalled$str() {
        return "WELD-000174: ProcessBeanAttributes.configureBeanAttributes() called by {0} for {1}";
    }
    @Override
    public final void ignoreFinalMethodsCalled(final Object extensionName, final Object bean) {
        super.log.logv(FQCN, DEBUG, null, ignoreFinalMethodsCalled$str(), extensionName, bean);
    }
    protected String ignoreFinalMethodsCalled$str() {
        return "WELD-000175: ProcessBeanAttributes.isIgnoreFinalMethods() called by {0} for {1}";
    }
    @Override
    public final void configureAnnotatedTypeCalled(final Object extensionName, final Object bean) {
        super.log.logv(FQCN, DEBUG, null, configureAnnotatedTypeCalled$str(), extensionName, bean);
    }
    protected String configureAnnotatedTypeCalled$str() {
        return "WELD-000176: ProcessAnnotatedType.configureAnnotatedType() called by {0} for {1}";
    }
    @Override
    public final void configureObserverMethodCalled(final Object extensionName, final Object bean) {
        super.log.logv(FQCN, DEBUG, null, configureObserverMethodCalled$str(), extensionName, bean);
    }
    protected String configureObserverMethodCalled$str() {
        return "WELD-000177: ProcessObserverMethod.configureObserverMethod() called by {0} for {1}";
    }
    @Override
    public final void configureInjectionPointCalled(final Object extensionName, final Object bean) {
        super.log.logv(FQCN, DEBUG, null, configureInjectionPointCalled$str(), extensionName, bean);
    }
    protected String configureInjectionPointCalled$str() {
        return "WELD-000178: ProcessInjectionPoint.configureInjectionPoint() called by {0} for {1}";
    }
    protected String unableToProcessConfigurator$str() {
        return "WELD-000179: {0} created by {1} cannot be processed";
    }
    @Override
    public final DeploymentException unableToProcessConfigurator(final Object configurator, final Object extensionName, final Throwable cause) {
        final DeploymentException result = new DeploymentException(_formatMessage(unableToProcessConfigurator$str(), configurator, extensionName), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void dropUnusedBeanMetadata(final Object bean) {
        super.log.logv(FQCN, DEBUG, null, dropUnusedBeanMetadata$str(), bean);
    }
    protected String dropUnusedBeanMetadata$str() {
        return "WELD-000180: Drop unused bean metadata: {0}";
    }
    @Override
    public final void commonThreadPoolWithSecurityManagerEnabled(final Object threadPoolType) {
        super.log.logv(FQCN, WARN, null, commonThreadPoolWithSecurityManagerEnabled$str(), threadPoolType);
    }
    protected String commonThreadPoolWithSecurityManagerEnabled$str() {
        return "WELD-000181: org.jboss.weld.executor.threadPoolType=COMMON detected but ForkJoinPool.commonPool() does not work with SecurityManager enabled, switching to {0} thread pool";
    }
    protected String proxyServicesWithoutClassDefining$str() {
        return "WELD-000182: Provided implementation of org.jboss.weld.serialization.spi.ProxyServices ({0}) does not support class defining. This functionality is required in order to be able to define proxy classes.";
    }
    @Override
    public final IllegalStateException proxyServicesWithoutClassDefining(final Object services) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(proxyServicesWithoutClassDefining$str(), services));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void catchingDebug(final Throwable throwable) {
        super.log.logf(FQCN, DEBUG, throwable, catchingDebug$str());
    }
    protected String catchingDebug$str() {
        return "Catching";
    }
}
