/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.deployment.discovery;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import javax.enterprise.inject.spi.Extension;
import org.jboss.logging.Logger;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.environment.deployment.discovery.AbstractBeanArchiveScanner;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveScanner;
import org.jboss.weld.environment.logging.CommonLogger;
import org.jboss.weld.security.GetSystemPropertyAction;
import org.jboss.weld.util.collections.ImmutableList;
import org.jboss.weld.util.collections.ImmutableSet;

public class ClassPathBeanArchiveScanner
extends AbstractBeanArchiveScanner {
    static final String JAVA_CLASS_PATH_SYSTEM_PROPERTY = "java.class.path";
    static final String EXTENSION_FILE = "META-INF/" + Extension.class.getName();
    private static final Logger logger = Logger.getLogger(ClassPathBeanArchiveScanner.class);
    private static final String BEANS_XML_FOUND_MESSAGE = "beans.xml found in {0}";
    private static final String BEANS_XML_NOT_FOUND_MESSAGE = "beans.xml not found in {0}";
    private static final String MANIFEST_FILE = "META-INF/MANIFEST.MF";
    private static final Pattern MANIFEST_CLASSPATH_SEPARATOR_PATTERN = Pattern.compile(" +");
    private final Set<URL> visitedManifestClassPathEntries = new HashSet<URL>();

    public ClassPathBeanArchiveScanner(Bootstrap bootstrap) {
        super(bootstrap);
    }

    @Override
    public List<BeanArchiveScanner.ScanResult> scan() {
        String javaClassPath = AccessController.doPrivileged(new GetSystemPropertyAction(JAVA_CLASS_PATH_SYSTEM_PROPERTY));
        if (javaClassPath == null) {
            throw CommonLogger.LOG.cannotReadJavaClassPathSystemProperty();
        }
        ImmutableList.Builder<BeanArchiveScanner.ScanResult> results = ImmutableList.builder();
        Set<String> entries = ImmutableSet.of(javaClassPath.split(Pattern.quote(File.pathSeparator)));
        logger.debugv("Scanning class path entries: {0}", (Object)entries);
        for (String entry : entries) {
            if (entry == null || entry.isEmpty()) continue;
            File entryFile = new File(entry);
            if (!entryFile.canRead()) {
                throw CommonLogger.LOG.cannotReadClassPathEntry(entryFile);
            }
            try {
                if (entryFile.isDirectory()) {
                    this.scanDirectory(entryFile, results);
                    continue;
                }
                this.scanJarFile(entryFile, results);
            }
            catch (IOException e) {
                throw CommonLogger.LOG.cannotScanClassPathEntry(entryFile, e);
            }
        }
        return results.build();
    }

    private void scanDirectory(File entryDirectory, ImmutableList.Builder<BeanArchiveScanner.ScanResult> results) throws IOException {
        File beansXmlFile = new File(entryDirectory, "META-INF/beans.xml");
        if (beansXmlFile.canRead()) {
            logger.debugv(BEANS_XML_FOUND_MESSAGE, (Object)entryDirectory);
            BeansXml beansXml = this.parseBeansXml(beansXmlFile.toURI().toURL());
            if (this.accept(beansXml)) {
                results.add(new BeanArchiveScanner.ScanResult(beansXml, entryDirectory.getPath()));
            }
        } else {
            logger.debugv(BEANS_XML_NOT_FOUND_MESSAGE, (Object)entryDirectory);
            File extensionFile = new File(entryDirectory, EXTENSION_FILE);
            if (!extensionFile.canRead()) {
                results.add(new BeanArchiveScanner.ScanResult(null, entryDirectory.getPath()));
            }
        }
        File manifestFile = new File(entryDirectory, MANIFEST_FILE);
        if (manifestFile.canRead()) {
            try (FileInputStream fis = new FileInputStream(manifestFile);){
                Manifest manifest = new Manifest(fis);
                Attributes manifestMainAttributes = manifest.getMainAttributes();
                if (manifestMainAttributes.containsKey(Attributes.Name.CLASS_PATH)) {
                    this.scanManifestClassPath(entryDirectory.toURI().toURL(), manifestMainAttributes.getValue(Attributes.Name.CLASS_PATH), results);
                }
            }
        }
    }

    private void scanJarFile(File entryFile, ImmutableList.Builder<BeanArchiveScanner.ScanResult> results) throws IOException {
        try (JarFile jar = new JarFile(entryFile);){
            Attributes manifestMainAttributes;
            JarEntry beansXmlEntry = jar.getJarEntry("META-INF/beans.xml");
            if (beansXmlEntry != null) {
                logger.debugv(BEANS_XML_FOUND_MESSAGE, (Object)entryFile);
                BeansXml beansXml = this.parseBeansXml(new URL("jar:" + entryFile.toURI().toURL().toExternalForm() + "!/" + beansXmlEntry.getName()));
                if (this.accept(beansXml)) {
                    results.add(new BeanArchiveScanner.ScanResult(beansXml, entryFile.getPath()));
                }
            } else if (jar.getEntry(EXTENSION_FILE) == null) {
                logger.debugv(BEANS_XML_NOT_FOUND_MESSAGE, (Object)entryFile);
                results.add(new BeanArchiveScanner.ScanResult(null, entryFile.getPath()));
            }
            Manifest manifest = jar.getManifest();
            if (manifest != null && (manifestMainAttributes = manifest.getMainAttributes()).containsKey(Attributes.Name.CLASS_PATH)) {
                this.scanManifestClassPath(entryFile.toURI().toURL(), manifestMainAttributes.getValue(Attributes.Name.CLASS_PATH), results);
            }
        }
    }

    private void scanManifestClassPath(URL context, String classPath, ImmutableList.Builder<BeanArchiveScanner.ScanResult> results) {
        Set<String> entries = ImmutableSet.of(MANIFEST_CLASSPATH_SEPARATOR_PATTERN.split(classPath));
        for (String entry : entries) {
            if (entry == null || entry.isEmpty()) continue;
            try {
                File entryFile;
                URL entryUrl = new URL(context, entry);
                if (!this.visitedManifestClassPathEntries.add(entryUrl) || !entryUrl.getProtocol().equals("file") || !(entryFile = new File(URI.create(entryUrl.toString()))).canRead()) continue;
                if (entry.endsWith("/")) {
                    this.scanDirectory(entryFile, results);
                    continue;
                }
                this.scanJarFile(entryFile, results);
            }
            catch (IOException e) {
                throw CommonLogger.LOG.cannotScanClassPathEntry(entry, e);
            }
        }
    }
}

