/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.inject;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.InjectionTarget;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.cache.ComputingCache;
import org.jboss.weld.util.cache.ComputingCacheBuilder;
import org.jboss.weld.util.reflection.Reflections;

public abstract class AbstractInjector {
    private final WeldManager manager;
    private final ComputingCache<Class<?>, InjectionTarget<?>> cache;

    protected AbstractInjector(WeldManager manager) {
        Preconditions.checkArgumentNotNull(manager, "manager");
        this.manager = manager;
        this.cache = ComputingCacheBuilder.newBuilder().setWeakValues().build(clazz -> {
            AnnotatedType type = manager.createAnnotatedType(clazz);
            return manager.createInjectionTargetBuilder(type).setResourceInjectionEnabled(false).setTargetClassLifecycleCallbacksEnabled(false).build();
        });
    }

    protected void inject(Object instance) {
        InjectionTarget it = (InjectionTarget)Reflections.cast(this.cache.getValue(instance.getClass()));
        CreationalContext cc = this.manager.createCreationalContext((Contextual)null);
        it.inject(instance, cc);
    }

    public void destroy(Object instance) {
        if (instance != null) {
            InjectionTarget it = (InjectionTarget)Reflections.cast(this.cache.getValue(instance.getClass()));
            it.dispose(instance);
        }
    }
}

