/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.jetty;

import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.jboss.weld.environment.jetty.JettyWeldInjector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.log.Log;

public class WeldServletHandler
extends ServletHandler {
    private ServletContext sco;
    private JettyWeldInjector injector;

    public WeldServletHandler(ServletHandler existingHandler, ServletContext servletContext) {
        this.sco = servletContext;
        this.setFilters(existingHandler.getFilters());
        this.setFilterMappings(existingHandler.getFilterMappings());
        this.setServlets(existingHandler.getServlets());
        this.setServletMappings(existingHandler.getServletMappings());
    }

    public Servlet customizeServlet(Servlet servlet) throws Exception {
        this.inject(servlet);
        return servlet;
    }

    public Filter customizeFilter(Filter filter) throws Exception {
        this.inject(filter);
        return filter;
    }

    protected void inject(Object injectable) {
        if (this.injector == null) {
            this.injector = (JettyWeldInjector)this.sco.getAttribute("org.jboss.weld.environment.jetty.JettyWeldInjector");
        }
        if (this.injector == null) {
            Log.warn((String)("Can't find Injector in the servlet context so injection is not available for " + injectable));
        } else {
            this.injector.inject(injectable);
        }
    }

    public static void process(WebAppContext wac) {
        WeldServletHandler wHanlder = new WeldServletHandler(wac.getServletHandler(), (ServletContext)wac.getServletContext());
        wac.setServletHandler((ServletHandler)wHanlder);
        wac.getSecurityHandler().setHandler((Handler)wHanlder);
    }
}

