/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.bean.proxy.DecoratorProxyMethodHandler;
import org.jboss.weld.bean.proxy.ProxyFactory;
import org.jboss.weld.bean.proxy.TargetBeanInstance;
import org.jboss.weld.context.SerializableContextualInstanceImpl;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.util.reflection.SecureReflections;

public class DecorationHelper<T> {
    private static ThreadLocal<Stack<DecorationHelper<?>>> helperStackHolder = new ThreadLocal<Stack<DecorationHelper<?>>>(){

        @Override
        protected Stack<DecorationHelper<?>> initialValue() {
            return new Stack();
        }
    };
    private final Class<T> proxyClassForDecorator;
    private final TargetBeanInstance targetBeanInstance;
    private T originalInstance;
    private T previousDelegate;
    private int counter;
    private BeanManagerImpl beanManager;
    private final ContextualStore contextualStore;
    private final Bean<?> bean;
    List<Decorator<?>> decorators;

    public DecorationHelper(TargetBeanInstance originalInstance, Bean<?> bean, Class<T> proxyClassForDecorator, BeanManagerImpl beanManager, ContextualStore contextualStore, List<Decorator<?>> decorators) {
        this.originalInstance = Reflections.cast(originalInstance.getInstance());
        this.targetBeanInstance = originalInstance;
        this.beanManager = beanManager;
        this.contextualStore = contextualStore;
        this.decorators = new LinkedList(decorators);
        this.proxyClassForDecorator = proxyClassForDecorator;
        this.bean = bean;
        this.counter = 0;
    }

    public static void push(DecorationHelper<?> helper) {
        helperStackHolder.get().push(helper);
    }

    public static DecorationHelper<?> peek() {
        return helperStackHolder.get().peek();
    }

    public static void pop() {
        Stack<DecorationHelper<?>> stack = helperStackHolder.get();
        stack.pop();
        if (stack.isEmpty()) {
            helperStackHolder.remove();
        }
    }

    public DecoratorProxyMethodHandler createMethodHandler(InjectionPoint injectionPoint, CreationalContext<?> creationalContext, Decorator<Object> decorator) {
        Object decoratorInstance = this.beanManager.getReference(injectionPoint, decorator, creationalContext);
        SerializableContextualInstanceImpl<Decorator<Object>, Object> serializableContextualInstance = new SerializableContextualInstanceImpl<Decorator<Object>, Object>(decorator, decoratorInstance, null, this.contextualStore);
        return new DecoratorProxyMethodHandler(serializableContextualInstance, this.previousDelegate);
    }

    public T getNextDelegate(InjectionPoint injectionPoint, CreationalContext<?> creationalContext) {
        if (this.counter == this.decorators.size()) {
            this.previousDelegate = this.originalInstance;
            return this.originalInstance;
        }
        try {
            T proxy = SecureReflections.newInstance(this.proxyClassForDecorator);
            TargetBeanInstance newTargetBeanInstance = new TargetBeanInstance(this.targetBeanInstance);
            newTargetBeanInstance.setInterceptorsHandler(this.createMethodHandler(injectionPoint, creationalContext, (Decorator)Reflections.cast(this.decorators.get(this.counter++))));
            ProxyFactory.setBeanInstance(proxy, newTargetBeanInstance, this.bean);
            this.previousDelegate = proxy;
            return proxy;
        }
        catch (InstantiationException e) {
            throw new WeldException(BeanMessage.PROXY_INSTANTIATION_FAILED, (Throwable)e, this);
        }
        catch (IllegalAccessException e) {
            throw new WeldException(BeanMessage.PROXY_INSTANTIATION_BEAN_ACCESS_FAILED, (Throwable)e, this);
        }
    }
}

