/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.metadata.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.annotation.Annotation;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.metadata.cache.AnnotationModel;
import org.jboss.weld.metadata.cache.InterceptorBindingModel;
import org.jboss.weld.metadata.cache.QualifierModel;
import org.jboss.weld.metadata.cache.ScopeModel;
import org.jboss.weld.metadata.cache.StereotypeModel;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.cache.LoadingCacheUtils;

public class MetaAnnotationStore
implements Service {
    private LoadingCache<Class<Annotation>, StereotypeModel<Annotation>> stereotypes;
    private LoadingCache<Class<Annotation>, ScopeModel<Annotation>> scopes;
    private LoadingCache<Class<Annotation>, QualifierModel<Annotation>> qualifiers;
    private LoadingCache<Class<Annotation>, InterceptorBindingModel<Annotation>> interceptorBindings;

    public MetaAnnotationStore(ClassTransformer classTransformer) {
        CacheBuilder<Object, Object> builder = CacheBuilder.newBuilder();
        this.stereotypes = builder.build(new StereotypeFunction(classTransformer));
        this.scopes = builder.build(new ScopeFunction(classTransformer));
        this.qualifiers = builder.build(new QualifierFunction(classTransformer));
        this.interceptorBindings = builder.build(new InterceptorBindingFunction(classTransformer));
    }

    public void clearAnnotationData(Class<? extends Annotation> annotationClass) {
        this.stereotypes.invalidate(annotationClass);
        this.scopes.invalidate(annotationClass);
        this.qualifiers.invalidate(annotationClass);
        this.interceptorBindings.invalidate(annotationClass);
    }

    public <T extends Annotation> StereotypeModel<T> getStereotype(Class<T> stereotype) {
        return (StereotypeModel)LoadingCacheUtils.getCastCacheValue(this.stereotypes, stereotype);
    }

    public <T extends Annotation> ScopeModel<T> getScopeModel(Class<T> scope) {
        return (ScopeModel)LoadingCacheUtils.getCastCacheValue(this.scopes, scope);
    }

    public <T extends Annotation> QualifierModel<T> getBindingTypeModel(Class<T> bindingType) {
        return (QualifierModel)LoadingCacheUtils.getCastCacheValue(this.qualifiers, bindingType);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Metadata cache\n");
        buffer.append("Registered binding type models: ").append(this.qualifiers.size()).append("\n");
        buffer.append("Registered scope type models: ").append(this.scopes.size()).append("\n");
        buffer.append("Registered stereotype models: ").append(this.stereotypes.size()).append("\n");
        buffer.append("Registered interceptor binding models: ").append(this.interceptorBindings.size()).append("\n");
        return buffer.toString();
    }

    @Override
    public void cleanup() {
        this.qualifiers.invalidateAll();
        this.scopes.invalidateAll();
        this.stereotypes.invalidateAll();
        this.interceptorBindings.invalidateAll();
    }

    public <T extends Annotation> InterceptorBindingModel<T> getInterceptorBindingModel(Class<T> interceptorBinding) {
        try {
            return (InterceptorBindingModel)LoadingCacheUtils.getCastCacheValue(this.interceptorBindings, interceptorBinding);
        }
        catch (UncheckedExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DeploymentException || cause instanceof DefinitionException) {
                throw (WeldException)cause;
            }
            throw e;
        }
    }

    private static class InterceptorBindingFunction
    extends AbstractMetaAnnotationFunction<InterceptorBindingModel<Annotation>> {
        public InterceptorBindingFunction(ClassTransformer classTransformer) {
            super(classTransformer);
        }

        @Override
        public InterceptorBindingModel<Annotation> load(Class<Annotation> from) {
            return new InterceptorBindingModel<Annotation>(from, this.getClassTransformer());
        }
    }

    private static class QualifierFunction
    extends AbstractMetaAnnotationFunction<QualifierModel<Annotation>> {
        public QualifierFunction(ClassTransformer classTransformer) {
            super(classTransformer);
        }

        @Override
        public QualifierModel<Annotation> load(Class<Annotation> from) {
            return new QualifierModel<Annotation>(from, this.getClassTransformer());
        }
    }

    private static class ScopeFunction
    extends AbstractMetaAnnotationFunction<ScopeModel<Annotation>> {
        public ScopeFunction(ClassTransformer classTransformer) {
            super(classTransformer);
        }

        @Override
        public ScopeModel<Annotation> load(Class<Annotation> from) {
            return new ScopeModel<Annotation>(from, this.getClassTransformer());
        }
    }

    private static class StereotypeFunction
    extends AbstractMetaAnnotationFunction<StereotypeModel<Annotation>> {
        public StereotypeFunction(ClassTransformer classTransformer) {
            super(classTransformer);
        }

        @Override
        public StereotypeModel<Annotation> load(Class<Annotation> from) {
            return new StereotypeModel<Annotation>(from, this.getClassTransformer());
        }
    }

    private static abstract class AbstractMetaAnnotationFunction<M extends AnnotationModel<Annotation>>
    extends CacheLoader<Class<Annotation>, M> {
        private final ClassTransformer classTransformer;

        private AbstractMetaAnnotationFunction(ClassTransformer classTransformer) {
            this.classTransformer = classTransformer;
        }

        public ClassTransformer getClassTransformer() {
            return this.classTransformer;
        }
    }
}

