/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javassist.util.proxy.ProxyObject;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.inject.Inject;
import org.jboss.weld.bean.ForwardingDecorator;
import org.jboss.weld.bean.ManagedBean;
import org.jboss.weld.bean.WeldDecorator;
import org.jboss.weld.bean.proxy.DecoratorProxy;
import org.jboss.weld.bean.proxy.DecoratorProxyFactory;
import org.jboss.weld.bean.proxy.ProxyMethodHandler;
import org.jboss.weld.bean.proxy.TargetBeanInstance;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.ForwardingInjectionTarget;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.introspector.MethodSignature;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.Decorators;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;

public class DecoratorImpl<T>
extends ManagedBean<T>
implements WeldDecorator<T> {
    private WeldClass<?> annotatedDelegateItem;
    private Map<MethodSignature, WeldMethod<?, ?>> decoratorMethods;
    private WeldInjectionPoint<?, ?> delegateInjectionPoint;
    private FieldInjectionPoint<?, ?> delegateFieldInjectionPoint;
    private Set<Annotation> delegateBindings;
    private Type delegateType;
    private Set<Type> delegateTypes;
    private Set<Type> decoratedTypes;

    public static <T> Decorator<T> wrap(final Decorator<T> decorator) {
        return new ForwardingDecorator<T>(){

            @Override
            public Set<Annotation> getQualifiers() {
                return this.delegate().getDelegateQualifiers();
            }

            @Override
            public Set<Type> getTypes() {
                return this.delegate().getTypes();
            }

            @Override
            protected Decorator<T> delegate() {
                return decorator;
            }
        };
    }

    public static <T> DecoratorImpl<T> of(WeldClass<T> clazz, BeanManagerImpl beanManager, ServiceRegistry services) {
        return new DecoratorImpl<T>(clazz, beanManager, services);
    }

    protected DecoratorImpl(WeldClass<T> type, BeanManagerImpl beanManager, ServiceRegistry services) {
        super(type, Decorator.class.getSimpleName() + "-" + type.getName(), beanManager, services);
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        if (!this.isInitialized()) {
            this.initDelegateInjectionPoint();
            super.initialize(environment);
            this.initDecoratedTypes();
            this.initDelegateBindings();
            this.initDelegateType();
            this.checkDelegateType();
            this.checkAbstractMethods();
        }
    }

    protected void initDecoratedTypes() {
        this.decoratedTypes = new HashSet<Type>(this.getWeldAnnotated().getInterfaceClosure());
        this.decoratedTypes.retainAll(this.getTypes());
        this.decoratedTypes.remove(Serializable.class);
        this.decoratorMethods = Decorators.getDecoratorMethods(this.beanManager, this.decoratedTypes, this.getWeldAnnotated());
    }

    protected void initDelegateInjectionPoint() {
        this.delegateInjectionPoint = this.getDelegateInjectionPoints().iterator().next();
        if (this.delegateInjectionPoint instanceof FieldInjectionPoint) {
            this.delegateFieldInjectionPoint = (FieldInjectionPoint)this.delegateInjectionPoint;
        }
    }

    @Override
    protected Class<T> createEnhancedSubclass() {
        return new DecoratorProxyFactory(this.getWeldAnnotated().getJavaClass(), this.delegateInjectionPoint, this).getProxyClass();
    }

    @Override
    protected boolean isSubclassed() {
        return this.getWeldAnnotated().isAbstract();
    }

    @Override
    protected void checkDelegateInjectionPoints() {
        for (WeldInjectionPoint<?, ?> injectionPoint : this.getDelegateInjectionPoints()) {
            if (!(injectionPoint instanceof MethodInjectionPoint) || injectionPoint.isAnnotationPresent(Inject.class)) continue;
            throw new DefinitionException(BeanMessage.DELEGATE_ON_NON_INITIALIZER_METHOD, injectionPoint);
        }
        if (this.getDelegateInjectionPoints().size() == 0) {
            throw new DefinitionException(BeanMessage.NO_DELEGATE_FOR_DECORATOR, this.getWeldAnnotated());
        }
        if (this.getDelegateInjectionPoints().size() > 1) {
            throw new DefinitionException(BeanMessage.TOO_MANY_DELEGATES_FOR_DECORATOR, this.getWeldAnnotated());
        }
    }

    protected void initDelegateBindings() {
        this.delegateBindings = new HashSet<Annotation>();
        this.delegateBindings.addAll(this.delegateInjectionPoint.getQualifiers());
    }

    protected void initDelegateType() {
        this.delegateType = this.delegateInjectionPoint.getBaseType();
        this.delegateTypes = new HashSet<Type>();
        this.delegateTypes.add(this.delegateType);
    }

    protected void checkDelegateType() {
        HashSet<Type> mostSpecificDecoratedTypes = new HashSet<Type>(Arrays.asList(this.getWeldAnnotated().getJavaClass().getGenericInterfaces()));
        mostSpecificDecoratedTypes.remove(Serializable.class);
        for (Type decoratedType : mostSpecificDecoratedTypes) {
            if (decoratedType instanceof Class) {
                if (((Class)decoratedType).isAssignableFrom(this.delegateInjectionPoint.getJavaClass())) continue;
                throw new DefinitionException(BeanMessage.DELEGATE_MUST_SUPPORT_EVERY_DECORATED_TYPE, decoratedType, this);
            }
            if (!(decoratedType instanceof ParameterizedType)) continue;
            ParameterizedType parameterizedType = (ParameterizedType)decoratedType;
            if (!this.delegateInjectionPoint.isParameterizedType()) {
                throw new DefinitionException(BeanMessage.DECORATED_TYPE_PARAMETERIZED_DELEGATE_NOT, this.delegateType, this);
            }
            if (!Arrays.equals(this.delegateInjectionPoint.getActualTypeArguments(), parameterizedType.getActualTypeArguments())) {
                throw new DefinitionException(BeanMessage.DELEGATE_TYPE_PARAMETER_MISMATCH, decoratedType, this);
            }
            Type rawType = ((ParameterizedType)decoratedType).getRawType();
            if (!(rawType instanceof Class) || ((Class)rawType).isAssignableFrom(this.delegateInjectionPoint.getJavaClass())) continue;
            throw new DefinitionException(BeanMessage.DELEGATE_MUST_SUPPORT_EVERY_DECORATED_TYPE, decoratedType, this);
        }
        this.annotatedDelegateItem = this.beanManager.getServices().get(ClassTransformer.class).loadClass(this.delegateInjectionPoint.getJavaClass());
    }

    private void checkAbstractMethods() {
        if (this.isSubclassed()) {
            for (WeldMethod method : this.getWeldAnnotated().getWeldMethods()) {
                MethodSignature methodSignature;
                if (!Reflections.isAbstract(method.getJavaMember()) || this.annotatedDelegateItem.getWeldMethod(methodSignature = method.getSignature()) != null || this.getWeldAnnotated().isMethodOverridden(method)) continue;
                throw new DefinitionException(BeanMessage.ABSTRACT_METHOD_MUST_MATCH_DECORATED_TYPE, method.getSignature(), this, this.getWeldAnnotated().getName());
            }
        }
    }

    @Override
    public InjectionTarget<T> getInjectionTarget() {
        final InjectionTarget delegate = super.getInjectionTarget();
        if (this.delegateFieldInjectionPoint != null) {
            return new ForwardingInjectionTarget<T>(){

                @Override
                protected InjectionTarget<T> delegate() {
                    return delegate;
                }

                @Override
                public void inject(T instance, CreationalContext<T> ctx) {
                    super.inject(instance, ctx);
                    if (DecoratorImpl.this.delegateFieldInjectionPoint != null && instance instanceof DecoratorProxy) {
                        Object delegate2 = DecoratorImpl.this.delegateFieldInjectionPoint.getWeldField().get(instance);
                        ProxyMethodHandler handler = new ProxyMethodHandler(new TargetBeanInstance(delegate2), DecoratorImpl.this);
                        ((ProxyObject)instance).setHandler(handler);
                    }
                }
            };
        }
        return delegate;
    }

    @Override
    public Set<Annotation> getDelegateQualifiers() {
        return this.delegateBindings;
    }

    @Override
    public Type getDelegateType() {
        return this.delegateType;
    }

    @Override
    public Set<Type> getDecoratedTypes() {
        return this.decoratedTypes;
    }

    public WeldInjectionPoint<?, ?> getDelegateInjectionPoint() {
        return this.delegateInjectionPoint;
    }

    @Override
    public void initDecorators() {
    }

    @Override
    public WeldMethod<?, ?> getDecoratorMethod(Method method) {
        return Decorators.findDecoratorMethod(this, this.decoratorMethods, method);
    }

    @Override
    public String toString() {
        return "Decorator [" + this.getBeanClass().toString() + "] decorates [" + Formats.formatTypes(this.getDecoratedTypes()) + "] with delegate type [" + Formats.formatType(this.getDelegateType()) + "] and delegate qualifiers [" + Formats.formatAnnotations(this.getDelegateQualifiers()) + "]";
    }
}

