/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.Container;
import org.jboss.weld.bean.proxy.ClientProxyFactory;
import org.jboss.weld.bean.proxy.ContextBeanInstance;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.cache.LoadingCacheUtils;
import org.slf4j.cal10n.LocLogger;

public class ClientProxyProvider {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);
    private static final CacheLoader<Bean<Object>, Object> CREATE_CLIENT_PROXY = new CacheLoader<Bean<Object>, Object>(){

        @Override
        public Object load(Bean<Object> from) {
            String id = Container.instance().services().get(ContextualStore.class).putIfAbsent(from);
            if (id == null) {
                throw new DefinitionException(BeanMessage.BEAN_ID_CREATION_FAILED, from);
            }
            return ClientProxyProvider.createClientProxy(from, id);
        }
    };
    private final LoadingCache<Bean<Object>, Object> pool = CacheBuilder.newBuilder().build(CREATE_CLIENT_PROXY);

    private static <T> T createClientProxy(Bean<T> bean, String id) throws RuntimeException {
        ContextBeanInstance<T> beanInstance = new ContextBeanInstance<T>(bean, id);
        Proxies.TypeInfo typeInfo = Proxies.TypeInfo.of(bean.getTypes());
        Object proxy = new ClientProxyFactory(typeInfo.getSuperClass(), bean.getTypes(), bean).create(beanInstance);
        log.trace(BeanMessage.CREATED_NEW_CLIENT_PROXY_TYPE, proxy.getClass(), bean, id);
        return proxy;
    }

    public <T> T getClientProxy(Bean<T> bean) {
        Object proxy = LoadingCacheUtils.getCastCacheValue(this.pool, bean);
        log.trace(BeanMessage.LOOKED_UP_CLIENT_PROXY, proxy.getClass(), bean);
        return proxy;
    }

    public String toString() {
        return "Proxy pool with " + this.pool.size() + " proxies";
    }

    public void clear() {
        this.pool.invalidateAll();
    }
}

