/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.jetty;

import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.jboss.weld.environment.jetty.JettyWeldInjector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.resource.Resource;

public class MortbayWeldServletHandler
extends ServletHandler {
    private static final Logger log = Logger.getLogger(MortbayWeldServletHandler.class.getName());
    private ServletContext sco;
    private JettyWeldInjector injector;

    public MortbayWeldServletHandler(ServletHandler existingHandler, ServletContext servletContext) {
        this.sco = servletContext;
        this.setFilters(existingHandler.getFilters());
        this.setFilterMappings(existingHandler.getFilterMappings());
        this.setServlets(existingHandler.getServlets());
        this.setServletMappings(existingHandler.getServletMappings());
    }

    public Servlet customizeServlet(Servlet servlet) throws Exception {
        this.inject(servlet);
        return servlet;
    }

    public Filter customizeFilter(Filter filter) throws Exception {
        this.inject(filter);
        return filter;
    }

    protected void inject(Object injectable) {
        if (this.injector == null) {
            this.injector = (JettyWeldInjector)this.sco.getAttribute("org.jboss.weld.environment.jetty.JettyWeldInjector");
        }
        if (this.injector == null) {
            log.warning("Can't find Injector in the servlet context so injection is not available for " + injectable);
        } else {
            this.injector.inject(injectable);
        }
    }

    protected static void process(WebAppContext wac, boolean startNewHandler) throws Exception {
        MortbayWeldServletHandler wHanlder = new MortbayWeldServletHandler(wac.getServletHandler(), (ServletContext)wac.getServletContext());
        wac.setServletHandler((ServletHandler)wHanlder);
        wac.getSecurityHandler().setHandler((Handler)wHanlder);
        if (startNewHandler) {
            wHanlder.start();
        }
        Resource jettyEnv = null;
        Resource webInf = wac.getWebInf();
        if (webInf != null && webInf.exists()) {
            jettyEnv = webInf.addPath("jetty-env.xml");
        }
        if (jettyEnv == null || !jettyEnv.exists()) {
            log.warning("Missing jetty-env.xml, no BeanManager present in JNDI.");
        }
    }

    public static void process(WebAppContext wac) throws Exception {
        MortbayWeldServletHandler.process(wac, false);
    }

    public static void process(ServletContext context) throws Exception {
        WebAppContext wac = (WebAppContext)WebAppContext.getCurrentWebAppContext();
        if (wac == null) {
            wac = MortbayWeldServletHandler.findWAC(context);
        }
        if (wac != null) {
            MortbayWeldServletHandler.process(wac, true);
        } else {
            log.info("Cannot find matching WebApplicationContext, no default CDI support: use jetty-web.xml");
        }
    }

    protected static WebAppContext findWAC(ServletContext context) {
        ServletHandler servletHandler;
        Server server;
        Handler serverHandler;
        ContextHandler.SContext sContext;
        ContextHandler contextHandler;
        Handler handler;
        if (context instanceof ContextHandler.SContext && (handler = (contextHandler = (sContext = (ContextHandler.SContext)context).getContextHandler()).getHandler()) instanceof ServletHandler && (serverHandler = (server = (servletHandler = (ServletHandler)handler).getServer()).getHandler()) instanceof HandlerCollection) {
            HandlerCollection hc = (HandlerCollection)serverHandler;
            for (Handler h : hc.getHandlers()) {
                WebAppContext wac;
                if (!(h instanceof WebAppContext) || (wac = (WebAppContext)h).getServletHandler() != servletHandler) continue;
                return wac;
            }
        }
        return null;
    }
}

