/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.util;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class ReflectionUtils {
    public static void ensureAccessible(final Method method) {
        ReflectionUtils.doSecurely(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                method.setAccessible(true);
                return null;
            }
        });
    }

    public static Class<?> classForName(String className) throws ClassNotFoundException {
        ClassLoader threadContextClassLoader = ReflectionUtils.getThreadContextClassLoader();
        if (threadContextClassLoader != null) {
            return threadContextClassLoader.loadClass(className);
        }
        return Class.forName(className);
    }

    public static ClassLoader getThreadContextClassLoader() {
        return ReflectionUtils.doSecurely(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private static <O> O doSecurely(PrivilegedAction<O> action) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(action);
        }
        return action.run();
    }
}

