/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resources;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ExecutionError;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.enterprise.inject.spi.AnnotatedType;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.introspector.ForwardingAnnotatedType;
import org.jboss.weld.introspector.WeldAnnotation;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.jlr.WeldAnnotationImpl;
import org.jboss.weld.introspector.jlr.WeldClassImpl;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.metadata.TypeStore;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.util.cache.LoadingCacheUtils;
import org.slf4j.Logger;

public class ClassTransformer
implements Service {
    private static Logger log = LoggerFactory.loggerFactory().getLogger(Category.CLASS_LOADING);
    private final LoadingCache<TypeHolder<?>, WeldClass<?>> classes;
    private final LoadingCache<AnnotatedType<?>, WeldClass<?>> annotatedTypes;
    private final LoadingCache<Class<? extends Annotation>, WeldAnnotation<?>> annotations;
    private final TypeStore typeStore;

    public ClassTransformer(TypeStore typeStore) {
        CacheBuilder<Object, Object> builder = CacheBuilder.newBuilder();
        this.classes = builder.build(new TransformTypeToWeldClass(this));
        this.annotatedTypes = builder.build(new TransformAnnotatedTypeToWeldClass(this));
        this.annotations = builder.build(new TransformClassToWeldAnnotation(this));
        this.typeStore = typeStore;
    }

    public <T> WeldClass<T> loadClass(Class<T> rawType, Type baseType) {
        return this.getWeldClass(this.classes, new TypeHolder(rawType, baseType));
    }

    public <T> WeldClass<T> loadClass(Class<T> clazz) {
        return this.getWeldClass(this.classes, new TypeHolder(clazz, clazz));
    }

    public void clearAnnotationData(Class<? extends Annotation> annotationClass) {
        this.annotations.invalidate(annotationClass);
    }

    public <T> WeldClass<T> loadClass(AnnotatedType<T> clazz) {
        if (clazz instanceof WeldClass) {
            return (WeldClass)clazz;
        }
        if (clazz instanceof ForwardingAnnotatedType && ((ForwardingAnnotatedType)clazz).delegate() instanceof WeldClass) {
            ForwardingAnnotatedType fat = (ForwardingAnnotatedType)clazz;
            return (WeldClass)fat.delegate();
        }
        return (WeldClass)LoadingCacheUtils.getCastCacheValue(this.annotatedTypes, clazz);
    }

    public <T extends Annotation> WeldAnnotation<T> loadAnnotation(Class<T> clazz) {
        return (WeldAnnotation)LoadingCacheUtils.getCastCacheValue(this.annotations, clazz);
    }

    public TypeStore getTypeStore() {
        return this.typeStore;
    }

    @Override
    public void cleanup() {
        this.annotatedTypes.invalidateAll();
        this.annotations.invalidateAll();
        this.classes.invalidateAll();
    }

    private <T> WeldClass<T> getWeldClass(LoadingCache<TypeHolder<?>, WeldClass<?>> classes, TypeHolder<T> key) {
        try {
            return (WeldClass)LoadingCacheUtils.getCastCacheValue(classes, key);
        }
        catch (RuntimeException e) {
            if (e instanceof TypeNotPresentException || e instanceof ResourceLoadingException) {
                throw new ResourceLoadingException("Exception while loading class " + key.getRawType().getName(), e);
            }
            log.trace("Exception while loading class '{}' : {}", (Object)key.getRawType().getName(), (Object)e);
            throw e;
        }
        catch (ExecutionError e) {
            Throwable cause = e.getCause();
            if (cause instanceof NoClassDefFoundError || cause instanceof LinkageError) {
                throw new ResourceLoadingException("Error while loading class " + key.getRawType().getName(), cause);
            }
            log.trace("Error while loading class '{}' : {}", (Object)key.getRawType().getName(), (Object)cause);
            throw e;
        }
    }

    private static final class TypeHolder<T> {
        private final Class<T> rawType;
        private final Type baseType;

        private TypeHolder(Class<T> rawType, Type baseType) {
            this.rawType = rawType;
            this.baseType = baseType;
        }

        public Type getBaseType() {
            return this.baseType;
        }

        public Class<T> getRawType() {
            return this.rawType;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeHolder) {
                TypeHolder that = (TypeHolder)obj;
                return this.getBaseType().equals(that.getBaseType());
            }
            return false;
        }

        public int hashCode() {
            return this.getBaseType().hashCode();
        }

        public String toString() {
            return this.getBaseType().toString();
        }
    }

    private static class TransformAnnotatedTypeToWeldClass
    extends CacheLoader<AnnotatedType<?>, WeldClass<?>> {
        private final ClassTransformer classTransformer;

        private TransformAnnotatedTypeToWeldClass(ClassTransformer classTransformer) {
            this.classTransformer = classTransformer;
        }

        @Override
        public WeldClass<?> load(AnnotatedType<?> from) {
            return WeldClassImpl.of(from, this.classTransformer);
        }
    }

    private static class TransformClassToWeldAnnotation
    extends CacheLoader<Class<? extends Annotation>, WeldAnnotation<?>> {
        private final ClassTransformer classTransformer;

        private TransformClassToWeldAnnotation(ClassTransformer classTransformer) {
            this.classTransformer = classTransformer;
        }

        @Override
        public WeldAnnotation<?> load(Class<? extends Annotation> from) {
            return WeldAnnotationImpl.create(from, this.classTransformer);
        }
    }

    private static class TransformTypeToWeldClass
    extends CacheLoader<TypeHolder<?>, WeldClass<?>> {
        private final ClassTransformer classTransformer;

        private TransformTypeToWeldClass(ClassTransformer classTransformer) {
            this.classTransformer = classTransformer;
        }

        @Override
        public WeldClass<?> load(TypeHolder<?> from) {
            return WeldClassImpl.of(from.getRawType(), from.getBaseType(), this.classTransformer);
        }
    }
}

