/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.api.helpers;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Map;
import org.jboss.weld.bootstrap.api.Singleton;
import org.jboss.weld.bootstrap.api.SingletonProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCCLSingletonProvider
extends SingletonProvider {
    @Override
    public <T> Singleton<T> create(Class<? extends T> type) {
        return new TCCLSingleton();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TCCLSingleton<T>
    implements Singleton<T> {
        private final Map<ClassLoader, T> store = new Hashtable<ClassLoader, T>();

        private TCCLSingleton() {
        }

        @Override
        public T get() {
            T instance = this.store.get(this.getClassLoader());
            if (instance == null) {
                throw new IllegalStateException("Singleton not set for " + this.getClassLoader());
            }
            return instance;
        }

        @Override
        public void set(T object) {
            System.out.println("Adding singleton for " + this.getClassLoader());
            this.store.put(this.getClassLoader(), object);
        }

        @Override
        public void clear() {
            this.store.remove(this.getClassLoader());
        }

        @Override
        public boolean isSet() {
            return this.store.containsKey(this.getClassLoader());
        }

        private ClassLoader getClassLoader() {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
            }
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

