/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.jsf;

import javax.el.ELContextListener;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.jboss.weld.environment.servlet.Listener;
import org.jboss.weld.environment.servlet.jsf.ForwardingApplication;
import org.jboss.weld.environment.servlet.portlet.PortletSupport;
import org.jboss.weld.environment.servlet.util.ForwardingELResolver;
import org.jboss.weld.environment.servlet.util.Reflections;
import org.jboss.weld.environment.servlet.util.TransparentELResolver;

public class WeldApplication
extends ForwardingApplication {
    private final Application application;
    private LazyBeanManagerIntegrationELResolver elResolver;
    private ExpressionFactory expressionFactory;
    private BeanManager beanManager;

    public WeldApplication(Application application) {
        this.application = application;
        application.addELContextListener((ELContextListener)Reflections.newInstance("org.jboss.weld.el.WeldELContextListener"));
        this.elResolver = new LazyBeanManagerIntegrationELResolver();
        application.addELResolver((ELResolver)this.elResolver);
    }

    private void init() {
        ExpressionFactory expressionFactory = null;
        BeanManager beanManager = null;
        if (expressionFactory == null && (expressionFactory = this.application.getExpressionFactory()) != null && (beanManager = this.beanManager()) != null) {
            this.elResolver.beanManagerReady(beanManager);
            this.expressionFactory = beanManager.wrapExpressionFactory(expressionFactory);
        }
    }

    @Override
    protected Application delegate() {
        this.init();
        return this.application;
    }

    @Override
    public ExpressionFactory getExpressionFactory() {
        this.init();
        if (this.expressionFactory == null) {
            return this.application.getExpressionFactory();
        }
        return this.expressionFactory;
    }

    private BeanManager beanManager() {
        FacesContext facesContext;
        if (this.beanManager == null && (facesContext = FacesContext.getCurrentInstance()) != null) {
            Object obj = facesContext.getExternalContext().getContext();
            boolean notFound = false;
            try {
                if (obj instanceof ServletContext) {
                    ServletContext ctx = (ServletContext)obj;
                    BeanManager tmp = (BeanManager)ctx.getAttribute(Listener.BEAN_MANAGER_ATTRIBUTE_NAME);
                    if (tmp == null) {
                        return null;
                    }
                    this.beanManager = tmp;
                } else if (PortletSupport.isPortletEnvSupported() && PortletSupport.isPortletContext(obj)) {
                    BeanManager tmp = PortletSupport.getBeanManager(obj);
                    if (tmp == null) {
                        return null;
                    }
                    this.beanManager = tmp;
                } else {
                    notFound = true;
                }
            }
            catch (Throwable t) {
                throw new IllegalStateException("Exception fetching BeanManager instance!", t);
            }
            if (notFound) {
                throw new IllegalStateException("Not in a servlet or portlet environment!");
            }
        }
        return this.beanManager;
    }

    private static class LazyBeanManagerIntegrationELResolver
    extends ForwardingELResolver {
        private ELResolver delegate = new TransparentELResolver();

        public void beanManagerReady(BeanManager beanManager) {
            this.delegate = beanManager.getELResolver();
        }

        @Override
        protected ELResolver delegate() {
            return this.delegate;
        }
    }
}

