/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.jboss.weld.bootstrap.spi.Metadata;

public class ServiceLoader {
    private static final String JDK_SERVICE_LOADER = "java.util.ServiceLoader";
    private static final String WELD_SERVICE_LOADER = "org.jboss.weld.util.ServiceLoader";
    private static final Method loadMethod;
    private static boolean weldSL;

    private static Iterable adapt(Iterable iterable) {
        if (weldSL) {
            ArrayList list = new ArrayList();
            for (Object o : iterable) {
                Metadata md = (Metadata)o;
                list.add(md.getValue());
            }
            return list;
        }
        return iterable;
    }

    public static <S> Iterable<S> load(Class<S> service) {
        return ServiceLoader.load(service, Thread.currentThread().getContextClassLoader());
    }

    public static <S> Iterable<S> load(Class<S> service, ClassLoader loader) {
        if (loader == null) {
            loader = service.getClassLoader();
        }
        try {
            return ServiceLoader.adapt((Iterable)loadMethod.invoke(null, service, loader));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        weldSL = false;
        ClassLoader cl = ServiceLoader.class.getClassLoader();
        Class<?> clazz = null;
        try {
            clazz = cl.loadClass(JDK_SERVICE_LOADER);
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        if (clazz == null) {
            try {
                clazz = cl.loadClass(WELD_SERVICE_LOADER);
                weldSL = true;
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
        if (clazz == null) {
            throw new IllegalArgumentException("No ServiceLoader class available!");
        }
        try {
            loadMethod = clazz.getDeclaredMethod("load", Class.class, ClassLoader.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("No load method available on ServiceLoader - " + clazz, e);
        }
    }
}

