/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection;

import com.google.common.collect.ImmutableMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.TransientReference;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.injection.AbstractCallableInjectionPoint;
import org.jboss.weld.injection.Exceptions;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.security.GetAccessibleCopyOfMember;
import org.jboss.weld.security.MethodLookupAction;
import org.jboss.weld.util.reflection.Reflections;

public class MethodInjectionPoint<T, X>
extends AbstractCallableInjectionPoint<T, X, Method> {
    private final AnnotatedMethod<X> annotatedMethod;
    private final Method accessibleMethod;
    private volatile Map<Class<?>, Method> methods;

    protected MethodInjectionPoint(EnhancedAnnotatedMethod<T, X> enhancedMethod, Bean<?> declaringBean, Class<?> declaringComponentClass, boolean observerOrDisposer, InjectionPointFactory factory, BeanManagerImpl manager) {
        super(enhancedMethod, declaringBean, declaringComponentClass, observerOrDisposer, factory, manager);
        this.annotatedMethod = enhancedMethod.slim();
        this.accessibleMethod = AccessController.doPrivileged(new GetAccessibleCopyOfMember<Method>(this.annotatedMethod.getJavaMember()));
        this.methods = Collections.singletonMap(this.annotatedMethod.getJavaMember().getDeclaringClass(), this.accessibleMethod);
    }

    public T invoke(Object declaringInstance, BeanManagerImpl manager, CreationalContext<?> creationalContext, Class<? extends RuntimeException> exceptionTypeToThrow) {
        return this.invokeWithSpecialValue(declaringInstance, null, null, manager, creationalContext, exceptionTypeToThrow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T invokeWithSpecialValue(Object declaringInstance, Class<? extends Annotation> annotatedParameter, Object parameter, BeanManagerImpl manager, CreationalContext<?> ctx, Class<? extends RuntimeException> exceptionTypeToThrow) {
        CreationalContext invocationContext = manager.createCreationalContext((Contextual)null);
        try {
            Object t = Reflections.cast(this.accessibleMethod.invoke(declaringInstance, this.getParameterValues(annotatedParameter, parameter, manager, ctx, invocationContext)));
            return t;
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        catch (InvocationTargetException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        finally {
            invocationContext.release();
        }
        return null;
    }

    public T invokeOnInstance(Object declaringInstance, BeanManagerImpl manager, CreationalContext<?> creationalContext, Class<? extends RuntimeException> exceptionTypeToThrow) {
        return this.invokeOnInstanceWithSpecialValue(declaringInstance, null, null, manager, creationalContext, exceptionTypeToThrow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T invokeOnInstanceWithSpecialValue(Object declaringInstance, Class<? extends Annotation> annotatedParameter, Object parameter, BeanManagerImpl manager, CreationalContext<?> ctx, Class<? extends RuntimeException> exceptionTypeToThrow) {
        CreationalContext invocationContext = manager.createCreationalContext((Contextual)null);
        try {
            Method method = this.getMethodFromClass(declaringInstance.getClass());
            Object t = Reflections.cast(method.invoke(declaringInstance, this.getParameterValues(annotatedParameter, parameter, manager, ctx, invocationContext)));
            return t;
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        catch (SecurityException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        catch (InvocationTargetException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        catch (NoSuchMethodException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        finally {
            invocationContext.release();
        }
        return null;
    }

    protected Object[] getParameterValues(Class<? extends Annotation> specialParam, Object specialVal, BeanManagerImpl manager, CreationalContext<?> ctx, CreationalContext<?> invocationContext) {
        Object[] parameterValues = new Object[this.getParameterInjectionPoints().size()];
        Iterator iterator = this.getParameterInjectionPoints().iterator();
        for (int i = 0; i < parameterValues.length; ++i) {
            ParameterInjectionPoint param = (ParameterInjectionPoint)iterator.next();
            parameterValues[i] = specialParam != null && param.getAnnotated().isAnnotationPresent(specialParam) ? specialVal : (param.getAnnotated().isAnnotationPresent(TransientReference.class) ? param.getValueToInject(manager, invocationContext) : param.getValueToInject(manager, ctx));
        }
        return parameterValues;
    }

    @Override
    public AnnotatedMethod<X> getAnnotated() {
        return this.annotatedMethod;
    }

    private Method getMethodFromClass(Class<?> clazz) throws NoSuchMethodException {
        Map<Class<?>, Method> methods = this.methods;
        Method method = this.methods.get(clazz);
        if (method == null) {
            ImmutableMap newMethods;
            Method delegate = this.annotatedMethod.getJavaMember();
            try {
                method = AccessController.doPrivileged(new MethodLookupAction(clazz, delegate.getName(), delegate.getParameterTypes()));
                if (!Modifier.isPublic(method.getModifiers())) {
                    method = AccessController.doPrivileged(new GetAccessibleCopyOfMember<Method>(method));
                }
            }
            catch (PrivilegedActionException e) {
                if (e.getCause() instanceof NoSuchMethodException) {
                    throw (NoSuchMethodException)e.getCause();
                }
                throw new WeldException(e.getCause());
            }
            this.methods = newMethods = ImmutableMap.builder().putAll(methods).put(clazz, (Object)method).build();
        }
        return method;
    }
}

