/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.exceptions;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.jboss.weld.exceptions.WeldExceptionMessage;
import org.jboss.weld.exceptions.WeldExceptionStringMessage;
import org.jboss.weld.logging.LoggerFactory;

public class WeldExceptionKeyMessage
implements WeldExceptionMessage,
Serializable {
    private static final long serialVersionUID = 3474682221381024558L;
    private static final String EXCEPTION_MESSAGE_FOR_KEY = "Exception message for key ";
    private Enum<?> messageKey;
    private String[] messageArguments;

    public <E extends Enum<?>> WeldExceptionKeyMessage(E key, Object ... args) {
        this.messageKey = key;
        if (args != null && args.length > 0) {
            this.messageArguments = new String[args.length];
            int index = 0;
            for (Object arg : args) {
                this.messageArguments[index++] = String.valueOf(arg);
            }
        }
    }

    @Override
    public String getAsString() {
        String result = null;
        try {
            result = LoggerFactory.loggerFactory().getMessageConveyor().getMessage(this.messageKey, (Object[])this.messageArguments);
        }
        catch (Exception e) {
            result = EXCEPTION_MESSAGE_FOR_KEY + this.messageKey + " not found due to " + e.getLocalizedMessage();
        }
        if (result == null) {
            result = EXCEPTION_MESSAGE_FOR_KEY + this.messageKey + " not found";
        }
        return result;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new WeldExceptionStringMessage(this.getAsString());
    }
}

