/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.serialization;

import com.google.common.base.Objects;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.enterprise.inject.spi.AnnotatedMethod;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.interceptor.spi.metadata.MethodMetadata;
import org.jboss.weld.logging.messages.ReflectionMessage;
import org.jboss.weld.serialization.AbstractSerializableHolder;

public class MethodHolder
extends AbstractSerializableHolder<Method>
implements PrivilegedAction<Method> {
    private static final long serialVersionUID = -3033089710155551280L;
    private final Class<?> declaringClass;
    private final String methodName;
    private final Class<?>[] parameterTypes;

    public MethodHolder(Method method) {
        super(method);
        this.declaringClass = method.getDeclaringClass();
        this.methodName = method.getName();
        this.parameterTypes = method.getParameterTypes();
    }

    public static MethodHolder of(Method method) {
        return new MethodHolder(method);
    }

    public static MethodHolder of(AnnotatedMethod<?> method) {
        return new MethodHolder(method.getJavaMember());
    }

    public static MethodHolder of(MethodMetadata method) {
        return new MethodHolder(method.getJavaMethod());
    }

    @Override
    protected Method initialize() {
        return AccessController.doPrivileged(this);
    }

    @Override
    public Method run() {
        try {
            return this.declaringClass.getDeclaredMethod(this.methodName, this.parameterTypes);
        }
        catch (Exception e) {
            throw new WeldException(ReflectionMessage.UNABLE_TO_GET_METHOD_ON_DESERIALIZATION, (Throwable)e, this.declaringClass, this.parameterTypes);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodHolder that = (MethodHolder)o;
        return Objects.equal(this.get(), that.get());
    }

    public int hashCode() {
        return ((Method)this.get()).hashCode();
    }
}

